/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.AggregationResourceType;
import com.amazonaws.services.inspector2.model.SortOrder;
import com.amazonaws.services.inspector2.model.StringFilter;
import com.amazonaws.services.inspector2.model.TitleSortBy;
import com.amazonaws.services.inspector2.model.transform.TitleAggregationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TitleAggregation
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private String sortBy;
    private String sortOrder;
    private List<StringFilter> titles;
    private List<StringFilter> vulnerabilityIds;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public TitleAggregation withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public TitleAggregation withResourceType(AggregationResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public TitleAggregation withSortBy(String sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public TitleAggregation withSortBy(TitleSortBy sortBy) {
        this.sortBy = sortBy.toString();
        return this;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public TitleAggregation withSortOrder(String sortOrder) {
        this.setSortOrder(sortOrder);
        return this;
    }

    public TitleAggregation withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder.toString();
        return this;
    }

    public List<StringFilter> getTitles() {
        return this.titles;
    }

    public void setTitles(Collection<StringFilter> titles) {
        if (titles == null) {
            this.titles = null;
            return;
        }
        this.titles = new ArrayList<StringFilter>(titles);
    }

    public TitleAggregation withTitles(StringFilter ... titles) {
        if (this.titles == null) {
            this.setTitles(new ArrayList<StringFilter>(titles.length));
        }
        for (StringFilter ele : titles) {
            this.titles.add(ele);
        }
        return this;
    }

    public TitleAggregation withTitles(Collection<StringFilter> titles) {
        this.setTitles(titles);
        return this;
    }

    public List<StringFilter> getVulnerabilityIds() {
        return this.vulnerabilityIds;
    }

    public void setVulnerabilityIds(Collection<StringFilter> vulnerabilityIds) {
        if (vulnerabilityIds == null) {
            this.vulnerabilityIds = null;
            return;
        }
        this.vulnerabilityIds = new ArrayList<StringFilter>(vulnerabilityIds);
    }

    public TitleAggregation withVulnerabilityIds(StringFilter ... vulnerabilityIds) {
        if (this.vulnerabilityIds == null) {
            this.setVulnerabilityIds(new ArrayList<StringFilter>(vulnerabilityIds.length));
        }
        for (StringFilter ele : vulnerabilityIds) {
            this.vulnerabilityIds.add(ele);
        }
        return this;
    }

    public TitleAggregation withVulnerabilityIds(Collection<StringFilter> vulnerabilityIds) {
        this.setVulnerabilityIds(vulnerabilityIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy()).append(",");
        }
        if (this.getSortOrder() != null) {
            sb.append("SortOrder: ").append(this.getSortOrder()).append(",");
        }
        if (this.getTitles() != null) {
            sb.append("Titles: ").append(this.getTitles()).append(",");
        }
        if (this.getVulnerabilityIds() != null) {
            sb.append("VulnerabilityIds: ").append(this.getVulnerabilityIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TitleAggregation)) {
            return false;
        }
        TitleAggregation other = (TitleAggregation)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        if (other.getSortBy() != null && !other.getSortBy().equals(this.getSortBy())) {
            return false;
        }
        if (other.getSortOrder() == null ^ this.getSortOrder() == null) {
            return false;
        }
        if (other.getSortOrder() != null && !other.getSortOrder().equals(this.getSortOrder())) {
            return false;
        }
        if (other.getTitles() == null ^ this.getTitles() == null) {
            return false;
        }
        if (other.getTitles() != null && !other.getTitles().equals(this.getTitles())) {
            return false;
        }
        if (other.getVulnerabilityIds() == null ^ this.getVulnerabilityIds() == null) {
            return false;
        }
        return other.getVulnerabilityIds() == null || other.getVulnerabilityIds().equals(this.getVulnerabilityIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        hashCode = 31 * hashCode + (this.getSortOrder() == null ? 0 : this.getSortOrder().hashCode());
        hashCode = 31 * hashCode + (this.getTitles() == null ? 0 : this.getTitles().hashCode());
        hashCode = 31 * hashCode + (this.getVulnerabilityIds() == null ? 0 : this.getVulnerabilityIds().hashCode());
        return hashCode;
    }

    public TitleAggregation clone() {
        try {
            return (TitleAggregation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TitleAggregationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

