/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.inspector2.model.AggregationResponse;
import com.amazonaws.services.inspector2.model.AggregationType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFindingAggregationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String aggregationType;
    private String nextToken;
    private List<AggregationResponse> responses;

    public void setAggregationType(String aggregationType) {
        this.aggregationType = aggregationType;
    }

    public String getAggregationType() {
        return this.aggregationType;
    }

    public ListFindingAggregationsResult withAggregationType(String aggregationType) {
        this.setAggregationType(aggregationType);
        return this;
    }

    public ListFindingAggregationsResult withAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListFindingAggregationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<AggregationResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(Collection<AggregationResponse> responses) {
        if (responses == null) {
            this.responses = null;
            return;
        }
        this.responses = new ArrayList<AggregationResponse>(responses);
    }

    public ListFindingAggregationsResult withResponses(AggregationResponse ... responses) {
        if (this.responses == null) {
            this.setResponses(new ArrayList<AggregationResponse>(responses.length));
        }
        for (AggregationResponse ele : responses) {
            this.responses.add(ele);
        }
        return this;
    }

    public ListFindingAggregationsResult withResponses(Collection<AggregationResponse> responses) {
        this.setResponses(responses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAggregationType() != null) {
            sb.append("AggregationType: ").append(this.getAggregationType()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getResponses() != null) {
            sb.append("Responses: ").append(this.getResponses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregationsResult)) {
            return false;
        }
        ListFindingAggregationsResult other = (ListFindingAggregationsResult)obj;
        if (other.getAggregationType() == null ^ this.getAggregationType() == null) {
            return false;
        }
        if (other.getAggregationType() != null && !other.getAggregationType().equals(this.getAggregationType())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getResponses() == null ^ this.getResponses() == null) {
            return false;
        }
        return other.getResponses() == null || other.getResponses().equals(this.getResponses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAggregationType() == null ? 0 : this.getAggregationType().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getResponses() == null ? 0 : this.getResponses().hashCode());
        return hashCode;
    }

    public ListFindingAggregationsResult clone() {
        try {
            return (ListFindingAggregationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

