/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Currency;
import com.amazonaws.services.inspector2.model.UsageType;
import com.amazonaws.services.inspector2.model.transform.UsageMarshaller;
import java.io.Serializable;

public class Usage
implements Serializable,
Cloneable,
StructuredPojo {
    private String currency;
    private Double estimatedMonthlyCost;
    private Double total;
    private String type;

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getCurrency() {
        return this.currency;
    }

    public Usage withCurrency(String currency) {
        this.setCurrency(currency);
        return this;
    }

    public Usage withCurrency(Currency currency) {
        this.currency = currency.toString();
        return this;
    }

    public void setEstimatedMonthlyCost(Double estimatedMonthlyCost) {
        this.estimatedMonthlyCost = estimatedMonthlyCost;
    }

    public Double getEstimatedMonthlyCost() {
        return this.estimatedMonthlyCost;
    }

    public Usage withEstimatedMonthlyCost(Double estimatedMonthlyCost) {
        this.setEstimatedMonthlyCost(estimatedMonthlyCost);
        return this;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Double getTotal() {
        return this.total;
    }

    public Usage withTotal(Double total) {
        this.setTotal(total);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Usage withType(String type) {
        this.setType(type);
        return this;
    }

    public Usage withType(UsageType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrency() != null) {
            sb.append("Currency: ").append(this.getCurrency()).append(",");
        }
        if (this.getEstimatedMonthlyCost() != null) {
            sb.append("EstimatedMonthlyCost: ").append(this.getEstimatedMonthlyCost()).append(",");
        }
        if (this.getTotal() != null) {
            sb.append("Total: ").append(this.getTotal()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Usage)) {
            return false;
        }
        Usage other = (Usage)obj;
        if (other.getCurrency() == null ^ this.getCurrency() == null) {
            return false;
        }
        if (other.getCurrency() != null && !other.getCurrency().equals(this.getCurrency())) {
            return false;
        }
        if (other.getEstimatedMonthlyCost() == null ^ this.getEstimatedMonthlyCost() == null) {
            return false;
        }
        if (other.getEstimatedMonthlyCost() != null && !other.getEstimatedMonthlyCost().equals(this.getEstimatedMonthlyCost())) {
            return false;
        }
        if (other.getTotal() == null ^ this.getTotal() == null) {
            return false;
        }
        if (other.getTotal() != null && !other.getTotal().equals(this.getTotal())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrency() == null ? 0 : this.getCurrency().hashCode());
        hashCode = 31 * hashCode + (this.getEstimatedMonthlyCost() == null ? 0 : this.getEstimatedMonthlyCost().hashCode());
        hashCode = 31 * hashCode + (this.getTotal() == null ? 0 : this.getTotal().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public Usage clone() {
        try {
            return (Usage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UsageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

