/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector2.model.Cvss2;

@SdkInternalApi
public class Cvss2Marshaller {
    private static final MarshallingInfo<Double> BASESCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseScore").build();
    private static final MarshallingInfo<String> SCORINGVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scoringVector").build();
    private static final Cvss2Marshaller instance = new Cvss2Marshaller();

    public static Cvss2Marshaller getInstance() {
        return instance;
    }

    public void marshall(Cvss2 cvss2, ProtocolMarshaller protocolMarshaller) {
        if (cvss2 == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cvss2.getBaseScore(), BASESCORE_BINDING);
            protocolMarshaller.marshall((Object)cvss2.getScoringVector(), SCORINGVECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

