/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iotanalytics.model.DatasetContentStatus;
import com.amazonaws.services.iotanalytics.model.DatasetEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetDatasetContentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<DatasetEntry> entries;
    private Date timestamp;
    private DatasetContentStatus status;

    public List<DatasetEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(Collection<DatasetEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        this.entries = new ArrayList<DatasetEntry>(entries);
    }

    public GetDatasetContentResult withEntries(DatasetEntry ... entries) {
        if (this.entries == null) {
            this.setEntries(new ArrayList<DatasetEntry>(entries.length));
        }
        for (DatasetEntry ele : entries) {
            this.entries.add(ele);
        }
        return this;
    }

    public GetDatasetContentResult withEntries(Collection<DatasetEntry> entries) {
        this.setEntries(entries);
        return this;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public GetDatasetContentResult withTimestamp(Date timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setStatus(DatasetContentStatus status) {
        this.status = status;
    }

    public DatasetContentStatus getStatus() {
        return this.status;
    }

    public GetDatasetContentResult withStatus(DatasetContentStatus status) {
        this.setStatus(status);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntries() != null) {
            sb.append("Entries: ").append(this.getEntries()).append(",");
        }
        if (this.getTimestamp() != null) {
            sb.append("Timestamp: ").append(this.getTimestamp()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatasetContentResult)) {
            return false;
        }
        GetDatasetContentResult other = (GetDatasetContentResult)obj;
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        if (other.getEntries() != null && !other.getEntries().equals(this.getEntries())) {
            return false;
        }
        if (other.getTimestamp() == null ^ this.getTimestamp() == null) {
            return false;
        }
        if (other.getTimestamp() != null && !other.getTimestamp().equals(this.getTimestamp())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : this.getEntries().hashCode());
        hashCode = 31 * hashCode + (this.getTimestamp() == null ? 0 : this.getTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public GetDatasetContentResult clone() {
        try {
            return (GetDatasetContentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

