/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.AlarmAction;

@SdkInternalApi
public class AlarmActionMarshaller {
    private static final MarshallingInfo<StructuredPojo> SNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sns").build();
    private static final MarshallingInfo<StructuredPojo> IOTTOPICPUBLISH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iotTopicPublish").build();
    private static final MarshallingInfo<StructuredPojo> LAMBDA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lambda").build();
    private static final MarshallingInfo<StructuredPojo> IOTEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iotEvents").build();
    private static final MarshallingInfo<StructuredPojo> SQS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sqs").build();
    private static final MarshallingInfo<StructuredPojo> FIREHOSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firehose").build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDB").build();
    private static final MarshallingInfo<StructuredPojo> DYNAMODBV2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamoDBv2").build();
    private static final MarshallingInfo<StructuredPojo> IOTSITEWISE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iotSiteWise").build();
    private static final AlarmActionMarshaller instance = new AlarmActionMarshaller();

    public static AlarmActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlarmAction alarmAction, ProtocolMarshaller protocolMarshaller) {
        if (alarmAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)alarmAction.getSns(), SNS_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getIotTopicPublish(), IOTTOPICPUBLISH_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getLambda(), LAMBDA_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getIotEvents(), IOTEVENTS_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getSqs(), SQS_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getFirehose(), FIREHOSE_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getDynamoDB(), DYNAMODB_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getDynamoDBv2(), DYNAMODBV2_BINDING);
            protocolMarshaller.marshall((Object)alarmAction.getIotSiteWise(), IOTSITEWISE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

