/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotsecuretunneling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotsecuretunneling.model.ConnectionState;
import com.amazonaws.services.iotsecuretunneling.model.DestinationConfig;
import com.amazonaws.services.iotsecuretunneling.model.Tag;
import com.amazonaws.services.iotsecuretunneling.model.TimeoutConfig;
import com.amazonaws.services.iotsecuretunneling.model.TunnelStatus;
import com.amazonaws.services.iotsecuretunneling.model.transform.TunnelMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Tunnel
implements Serializable,
Cloneable,
StructuredPojo {
    private String tunnelId;
    private String tunnelArn;
    private String status;
    private ConnectionState sourceConnectionState;
    private ConnectionState destinationConnectionState;
    private String description;
    private DestinationConfig destinationConfig;
    private TimeoutConfig timeoutConfig;
    private List<Tag> tags;
    private Date createdAt;
    private Date lastUpdatedAt;

    public void setTunnelId(String tunnelId) {
        this.tunnelId = tunnelId;
    }

    public String getTunnelId() {
        return this.tunnelId;
    }

    public Tunnel withTunnelId(String tunnelId) {
        this.setTunnelId(tunnelId);
        return this;
    }

    public void setTunnelArn(String tunnelArn) {
        this.tunnelArn = tunnelArn;
    }

    public String getTunnelArn() {
        return this.tunnelArn;
    }

    public Tunnel withTunnelArn(String tunnelArn) {
        this.setTunnelArn(tunnelArn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Tunnel withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Tunnel withStatus(TunnelStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setSourceConnectionState(ConnectionState sourceConnectionState) {
        this.sourceConnectionState = sourceConnectionState;
    }

    public ConnectionState getSourceConnectionState() {
        return this.sourceConnectionState;
    }

    public Tunnel withSourceConnectionState(ConnectionState sourceConnectionState) {
        this.setSourceConnectionState(sourceConnectionState);
        return this;
    }

    public void setDestinationConnectionState(ConnectionState destinationConnectionState) {
        this.destinationConnectionState = destinationConnectionState;
    }

    public ConnectionState getDestinationConnectionState() {
        return this.destinationConnectionState;
    }

    public Tunnel withDestinationConnectionState(ConnectionState destinationConnectionState) {
        this.setDestinationConnectionState(destinationConnectionState);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Tunnel withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDestinationConfig(DestinationConfig destinationConfig) {
        this.destinationConfig = destinationConfig;
    }

    public DestinationConfig getDestinationConfig() {
        return this.destinationConfig;
    }

    public Tunnel withDestinationConfig(DestinationConfig destinationConfig) {
        this.setDestinationConfig(destinationConfig);
        return this;
    }

    public void setTimeoutConfig(TimeoutConfig timeoutConfig) {
        this.timeoutConfig = timeoutConfig;
    }

    public TimeoutConfig getTimeoutConfig() {
        return this.timeoutConfig;
    }

    public Tunnel withTimeoutConfig(TimeoutConfig timeoutConfig) {
        this.setTimeoutConfig(timeoutConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Tunnel withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Tunnel withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Tunnel withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setLastUpdatedAt(Date lastUpdatedAt) {
        this.lastUpdatedAt = lastUpdatedAt;
    }

    public Date getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Tunnel withLastUpdatedAt(Date lastUpdatedAt) {
        this.setLastUpdatedAt(lastUpdatedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTunnelId() != null) {
            sb.append("TunnelId: ").append(this.getTunnelId()).append(",");
        }
        if (this.getTunnelArn() != null) {
            sb.append("TunnelArn: ").append(this.getTunnelArn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getSourceConnectionState() != null) {
            sb.append("SourceConnectionState: ").append(this.getSourceConnectionState()).append(",");
        }
        if (this.getDestinationConnectionState() != null) {
            sb.append("DestinationConnectionState: ").append(this.getDestinationConnectionState()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDestinationConfig() != null) {
            sb.append("DestinationConfig: ").append(this.getDestinationConfig()).append(",");
        }
        if (this.getTimeoutConfig() != null) {
            sb.append("TimeoutConfig: ").append(this.getTimeoutConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getLastUpdatedAt() != null) {
            sb.append("LastUpdatedAt: ").append(this.getLastUpdatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tunnel)) {
            return false;
        }
        Tunnel other = (Tunnel)obj;
        if (other.getTunnelId() == null ^ this.getTunnelId() == null) {
            return false;
        }
        if (other.getTunnelId() != null && !other.getTunnelId().equals(this.getTunnelId())) {
            return false;
        }
        if (other.getTunnelArn() == null ^ this.getTunnelArn() == null) {
            return false;
        }
        if (other.getTunnelArn() != null && !other.getTunnelArn().equals(this.getTunnelArn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSourceConnectionState() == null ^ this.getSourceConnectionState() == null) {
            return false;
        }
        if (other.getSourceConnectionState() != null && !other.getSourceConnectionState().equals(this.getSourceConnectionState())) {
            return false;
        }
        if (other.getDestinationConnectionState() == null ^ this.getDestinationConnectionState() == null) {
            return false;
        }
        if (other.getDestinationConnectionState() != null && !other.getDestinationConnectionState().equals(this.getDestinationConnectionState())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDestinationConfig() == null ^ this.getDestinationConfig() == null) {
            return false;
        }
        if (other.getDestinationConfig() != null && !other.getDestinationConfig().equals(this.getDestinationConfig())) {
            return false;
        }
        if (other.getTimeoutConfig() == null ^ this.getTimeoutConfig() == null) {
            return false;
        }
        if (other.getTimeoutConfig() != null && !other.getTimeoutConfig().equals(this.getTimeoutConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getLastUpdatedAt() == null ^ this.getLastUpdatedAt() == null) {
            return false;
        }
        return other.getLastUpdatedAt() == null || other.getLastUpdatedAt().equals(this.getLastUpdatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTunnelId() == null ? 0 : this.getTunnelId().hashCode());
        hashCode = 31 * hashCode + (this.getTunnelArn() == null ? 0 : this.getTunnelArn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSourceConnectionState() == null ? 0 : this.getSourceConnectionState().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConnectionState() == null ? 0 : this.getDestinationConnectionState().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationConfig() == null ? 0 : this.getDestinationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTimeoutConfig() == null ? 0 : this.getTimeoutConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedAt() == null ? 0 : this.getLastUpdatedAt().hashCode());
        return hashCode;
    }

    public Tunnel clone() {
        try {
            return (Tunnel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TunnelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

