/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.ComponentUpdateType;
import com.amazonaws.services.iottwinmaker.model.PropertyRequest;
import com.amazonaws.services.iottwinmaker.model.transform.ComponentUpdateRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ComponentUpdateRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String componentTypeId;
    private String description;
    private Map<String, PropertyRequest> propertyUpdates;
    private String updateType;

    public void setComponentTypeId(String componentTypeId) {
        this.componentTypeId = componentTypeId;
    }

    public String getComponentTypeId() {
        return this.componentTypeId;
    }

    public ComponentUpdateRequest withComponentTypeId(String componentTypeId) {
        this.setComponentTypeId(componentTypeId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ComponentUpdateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, PropertyRequest> getPropertyUpdates() {
        return this.propertyUpdates;
    }

    public void setPropertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
        this.propertyUpdates = propertyUpdates;
    }

    public ComponentUpdateRequest withPropertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
        this.setPropertyUpdates(propertyUpdates);
        return this;
    }

    public ComponentUpdateRequest addPropertyUpdatesEntry(String key, PropertyRequest value) {
        if (null == this.propertyUpdates) {
            this.propertyUpdates = new HashMap<String, PropertyRequest>();
        }
        if (this.propertyUpdates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyUpdates.put(key, value);
        return this;
    }

    public ComponentUpdateRequest clearPropertyUpdatesEntries() {
        this.propertyUpdates = null;
        return this;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public ComponentUpdateRequest withUpdateType(String updateType) {
        this.setUpdateType(updateType);
        return this;
    }

    public ComponentUpdateRequest withUpdateType(ComponentUpdateType updateType) {
        this.updateType = updateType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getComponentTypeId() != null) {
            sb.append("ComponentTypeId: ").append(this.getComponentTypeId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPropertyUpdates() != null) {
            sb.append("PropertyUpdates: ").append(this.getPropertyUpdates()).append(",");
        }
        if (this.getUpdateType() != null) {
            sb.append("UpdateType: ").append(this.getUpdateType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentUpdateRequest)) {
            return false;
        }
        ComponentUpdateRequest other = (ComponentUpdateRequest)obj;
        if (other.getComponentTypeId() == null ^ this.getComponentTypeId() == null) {
            return false;
        }
        if (other.getComponentTypeId() != null && !other.getComponentTypeId().equals(this.getComponentTypeId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPropertyUpdates() == null ^ this.getPropertyUpdates() == null) {
            return false;
        }
        if (other.getPropertyUpdates() != null && !other.getPropertyUpdates().equals(this.getPropertyUpdates())) {
            return false;
        }
        if (other.getUpdateType() == null ^ this.getUpdateType() == null) {
            return false;
        }
        return other.getUpdateType() == null || other.getUpdateType().equals(this.getUpdateType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getComponentTypeId() == null ? 0 : this.getComponentTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyUpdates() == null ? 0 : this.getPropertyUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateType() == null ? 0 : this.getUpdateType().hashCode());
        return hashCode;
    }

    public ComponentUpdateRequest clone() {
        try {
            return (ComponentUpdateRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComponentUpdateRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

