/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.iotwireless.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * LoRaWANUpdateDeviceMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class LoRaWANUpdateDeviceMarshaller {

    private static final MarshallingInfo<String> DEVICEPROFILEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceProfileId").build();
    private static final MarshallingInfo<String> SERVICEPROFILEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceProfileId").build();
    private static final MarshallingInfo<StructuredPojo> ABPV1_1_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AbpV1_1").build();
    private static final MarshallingInfo<StructuredPojo> ABPV1_0_X_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AbpV1_0_x").build();
    private static final MarshallingInfo<StructuredPojo> FPORTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FPorts").build();

    private static final LoRaWANUpdateDeviceMarshaller instance = new LoRaWANUpdateDeviceMarshaller();

    public static LoRaWANUpdateDeviceMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(LoRaWANUpdateDevice loRaWANUpdateDevice, ProtocolMarshaller protocolMarshaller) {

        if (loRaWANUpdateDevice == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(loRaWANUpdateDevice.getDeviceProfileId(), DEVICEPROFILEID_BINDING);
            protocolMarshaller.marshall(loRaWANUpdateDevice.getServiceProfileId(), SERVICEPROFILEID_BINDING);
            protocolMarshaller.marshall(loRaWANUpdateDevice.getAbpV1_1(), ABPV1_1_BINDING);
            protocolMarshaller.marshall(loRaWANUpdateDevice.getAbpV1_0_x(), ABPV1_0_X_BINDING);
            protocolMarshaller.marshall(loRaWANUpdateDevice.getFPorts(), FPORTS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
