/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotwireless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotwireless.model.transform.GnssMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Gnss
implements Serializable,
Cloneable,
StructuredPojo {
    private String payload;
    private Float captureTime;
    private Float captureTimeAccuracy;
    private List<Float> assistPosition;
    private Float assistAltitude;
    private Boolean use2DSolver;

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String getPayload() {
        return this.payload;
    }

    public Gnss withPayload(String payload) {
        this.setPayload(payload);
        return this;
    }

    public void setCaptureTime(Float captureTime) {
        this.captureTime = captureTime;
    }

    public Float getCaptureTime() {
        return this.captureTime;
    }

    public Gnss withCaptureTime(Float captureTime) {
        this.setCaptureTime(captureTime);
        return this;
    }

    public void setCaptureTimeAccuracy(Float captureTimeAccuracy) {
        this.captureTimeAccuracy = captureTimeAccuracy;
    }

    public Float getCaptureTimeAccuracy() {
        return this.captureTimeAccuracy;
    }

    public Gnss withCaptureTimeAccuracy(Float captureTimeAccuracy) {
        this.setCaptureTimeAccuracy(captureTimeAccuracy);
        return this;
    }

    public List<Float> getAssistPosition() {
        return this.assistPosition;
    }

    public void setAssistPosition(Collection<Float> assistPosition) {
        if (assistPosition == null) {
            this.assistPosition = null;
            return;
        }
        this.assistPosition = new ArrayList<Float>(assistPosition);
    }

    public Gnss withAssistPosition(Float ... assistPosition) {
        if (this.assistPosition == null) {
            this.setAssistPosition(new ArrayList<Float>(assistPosition.length));
        }
        for (Float ele : assistPosition) {
            this.assistPosition.add(ele);
        }
        return this;
    }

    public Gnss withAssistPosition(Collection<Float> assistPosition) {
        this.setAssistPosition(assistPosition);
        return this;
    }

    public void setAssistAltitude(Float assistAltitude) {
        this.assistAltitude = assistAltitude;
    }

    public Float getAssistAltitude() {
        return this.assistAltitude;
    }

    public Gnss withAssistAltitude(Float assistAltitude) {
        this.setAssistAltitude(assistAltitude);
        return this;
    }

    public void setUse2DSolver(Boolean use2DSolver) {
        this.use2DSolver = use2DSolver;
    }

    public Boolean getUse2DSolver() {
        return this.use2DSolver;
    }

    public Gnss withUse2DSolver(Boolean use2DSolver) {
        this.setUse2DSolver(use2DSolver);
        return this;
    }

    public Boolean isUse2DSolver() {
        return this.use2DSolver;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPayload() != null) {
            sb.append("Payload: ").append(this.getPayload()).append(",");
        }
        if (this.getCaptureTime() != null) {
            sb.append("CaptureTime: ").append(this.getCaptureTime()).append(",");
        }
        if (this.getCaptureTimeAccuracy() != null) {
            sb.append("CaptureTimeAccuracy: ").append(this.getCaptureTimeAccuracy()).append(",");
        }
        if (this.getAssistPosition() != null) {
            sb.append("AssistPosition: ").append(this.getAssistPosition()).append(",");
        }
        if (this.getAssistAltitude() != null) {
            sb.append("AssistAltitude: ").append(this.getAssistAltitude()).append(",");
        }
        if (this.getUse2DSolver() != null) {
            sb.append("Use2DSolver: ").append(this.getUse2DSolver());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gnss)) {
            return false;
        }
        Gnss other = (Gnss)obj;
        if (other.getPayload() == null ^ this.getPayload() == null) {
            return false;
        }
        if (other.getPayload() != null && !other.getPayload().equals(this.getPayload())) {
            return false;
        }
        if (other.getCaptureTime() == null ^ this.getCaptureTime() == null) {
            return false;
        }
        if (other.getCaptureTime() != null && !other.getCaptureTime().equals(this.getCaptureTime())) {
            return false;
        }
        if (other.getCaptureTimeAccuracy() == null ^ this.getCaptureTimeAccuracy() == null) {
            return false;
        }
        if (other.getCaptureTimeAccuracy() != null && !other.getCaptureTimeAccuracy().equals(this.getCaptureTimeAccuracy())) {
            return false;
        }
        if (other.getAssistPosition() == null ^ this.getAssistPosition() == null) {
            return false;
        }
        if (other.getAssistPosition() != null && !other.getAssistPosition().equals(this.getAssistPosition())) {
            return false;
        }
        if (other.getAssistAltitude() == null ^ this.getAssistAltitude() == null) {
            return false;
        }
        if (other.getAssistAltitude() != null && !other.getAssistAltitude().equals(this.getAssistAltitude())) {
            return false;
        }
        if (other.getUse2DSolver() == null ^ this.getUse2DSolver() == null) {
            return false;
        }
        return other.getUse2DSolver() == null || other.getUse2DSolver().equals(this.getUse2DSolver());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        hashCode = 31 * hashCode + (this.getCaptureTime() == null ? 0 : this.getCaptureTime().hashCode());
        hashCode = 31 * hashCode + (this.getCaptureTimeAccuracy() == null ? 0 : this.getCaptureTimeAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getAssistPosition() == null ? 0 : this.getAssistPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAssistAltitude() == null ? 0 : this.getAssistAltitude().hashCode());
        hashCode = 31 * hashCode + (this.getUse2DSolver() == null ? 0 : this.getUse2DSolver().hashCode());
        return hashCode;
    }

    public Gnss clone() {
        try {
            return (Gnss)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GnssMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

