/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ivsrealtime.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Object specifying a stage.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/Stage" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Stage implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Stage ARN.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * Stage name.
     * </p>
     */
    private String name;
    /**
     * <p>
     * ID of the active session within the stage.
     * </p>
     */
    private String activeSessionId;
    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * Configuration object for individual participant recording, attached to the stage.
     * </p>
     */
    private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;
    /**
     * <p>
     * Summary information about various endpoints for a stage.
     * </p>
     */
    private StageEndpoints endpoints;

    /**
     * <p>
     * Stage ARN.
     * </p>
     * 
     * @param arn
     *        Stage ARN.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * Stage ARN.
     * </p>
     * 
     * @return Stage ARN.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * Stage ARN.
     * </p>
     * 
     * @param arn
     *        Stage ARN.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * Stage name.
     * </p>
     * 
     * @param name
     *        Stage name.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Stage name.
     * </p>
     * 
     * @return Stage name.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Stage name.
     * </p>
     * 
     * @param name
     *        Stage name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * ID of the active session within the stage.
     * </p>
     * 
     * @param activeSessionId
     *        ID of the active session within the stage.
     */

    public void setActiveSessionId(String activeSessionId) {
        this.activeSessionId = activeSessionId;
    }

    /**
     * <p>
     * ID of the active session within the stage.
     * </p>
     * 
     * @return ID of the active session within the stage.
     */

    public String getActiveSessionId() {
        return this.activeSessionId;
    }

    /**
     * <p>
     * ID of the active session within the stage.
     * </p>
     * 
     * @param activeSessionId
     *        ID of the active session within the stage.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withActiveSessionId(String activeSessionId) {
        setActiveSessionId(activeSessionId);
        return this;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
     *         for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     *         IVS has no constraints on tags beyond what is documented there.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     * 
     * @param tags
     *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See
     *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
     *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS
     *        has no constraints on tags beyond what is documented there.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     * 
     * @param tags
     *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See
     *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for
     *        details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS
     *        has no constraints on tags beyond what is documented there.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see Stage#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public Stage addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, attached to the stage.
     * </p>
     * 
     * @param autoParticipantRecordingConfiguration
     *        Configuration object for individual participant recording, attached to the stage.
     */

    public void setAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
        this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, attached to the stage.
     * </p>
     * 
     * @return Configuration object for individual participant recording, attached to the stage.
     */

    public AutoParticipantRecordingConfiguration getAutoParticipantRecordingConfiguration() {
        return this.autoParticipantRecordingConfiguration;
    }

    /**
     * <p>
     * Configuration object for individual participant recording, attached to the stage.
     * </p>
     * 
     * @param autoParticipantRecordingConfiguration
     *        Configuration object for individual participant recording, attached to the stage.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
        setAutoParticipantRecordingConfiguration(autoParticipantRecordingConfiguration);
        return this;
    }

    /**
     * <p>
     * Summary information about various endpoints for a stage.
     * </p>
     * 
     * @param endpoints
     *        Summary information about various endpoints for a stage.
     */

    public void setEndpoints(StageEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * <p>
     * Summary information about various endpoints for a stage.
     * </p>
     * 
     * @return Summary information about various endpoints for a stage.
     */

    public StageEndpoints getEndpoints() {
        return this.endpoints;
    }

    /**
     * <p>
     * Summary information about various endpoints for a stage.
     * </p>
     * 
     * @param endpoints
     *        Summary information about various endpoints for a stage.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Stage withEndpoints(StageEndpoints endpoints) {
        setEndpoints(endpoints);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getActiveSessionId() != null)
            sb.append("ActiveSessionId: ").append(getActiveSessionId()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getAutoParticipantRecordingConfiguration() != null)
            sb.append("AutoParticipantRecordingConfiguration: ").append(getAutoParticipantRecordingConfiguration()).append(",");
        if (getEndpoints() != null)
            sb.append("Endpoints: ").append(getEndpoints());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Stage == false)
            return false;
        Stage other = (Stage) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getActiveSessionId() == null ^ this.getActiveSessionId() == null)
            return false;
        if (other.getActiveSessionId() != null && other.getActiveSessionId().equals(this.getActiveSessionId()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getAutoParticipantRecordingConfiguration() == null ^ this.getAutoParticipantRecordingConfiguration() == null)
            return false;
        if (other.getAutoParticipantRecordingConfiguration() != null
                && other.getAutoParticipantRecordingConfiguration().equals(this.getAutoParticipantRecordingConfiguration()) == false)
            return false;
        if (other.getEndpoints() == null ^ this.getEndpoints() == null)
            return false;
        if (other.getEndpoints() != null && other.getEndpoints().equals(this.getEndpoints()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getActiveSessionId() == null) ? 0 : getActiveSessionId().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getAutoParticipantRecordingConfiguration() == null) ? 0 : getAutoParticipantRecordingConfiguration().hashCode());
        hashCode = prime * hashCode + ((getEndpoints() == null) ? 0 : getEndpoints().hashCode());
        return hashCode;
    }

    @Override
    public Stage clone() {
        try {
            return (Stage) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ivsrealtime.model.transform.StageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
