/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kafka.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/ListReplicators" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListReplicatorsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be
     * sent in the subsequent request to ListReplicators.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Returns replicators starting with given name.
     * </p>
     */
    private String replicatorNameFilter;

    /**
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in the response. If there are more results, the response includes
     *        a NextToken parameter.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If there are more results, the response includes
     *         a NextToken parameter.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If there are more results, the response includes a
     * NextToken parameter.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of results to return in the response. If there are more results, the response includes
     *        a NextToken parameter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReplicatorsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be
     * sent in the subsequent request to ListReplicators.
     * </p>
     * 
     * @param nextToken
     *        If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken
     *        should be sent in the subsequent request to ListReplicators.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be
     * sent in the subsequent request to ListReplicators.
     * </p>
     * 
     * @return If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken
     *         should be sent in the subsequent request to ListReplicators.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken should be
     * sent in the subsequent request to ListReplicators.
     * </p>
     * 
     * @param nextToken
     *        If the response of ListReplicators is truncated, it returns a NextToken in the response. This NextToken
     *        should be sent in the subsequent request to ListReplicators.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReplicatorsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Returns replicators starting with given name.
     * </p>
     * 
     * @param replicatorNameFilter
     *        Returns replicators starting with given name.
     */

    public void setReplicatorNameFilter(String replicatorNameFilter) {
        this.replicatorNameFilter = replicatorNameFilter;
    }

    /**
     * <p>
     * Returns replicators starting with given name.
     * </p>
     * 
     * @return Returns replicators starting with given name.
     */

    public String getReplicatorNameFilter() {
        return this.replicatorNameFilter;
    }

    /**
     * <p>
     * Returns replicators starting with given name.
     * </p>
     * 
     * @param replicatorNameFilter
     *        Returns replicators starting with given name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListReplicatorsRequest withReplicatorNameFilter(String replicatorNameFilter) {
        setReplicatorNameFilter(replicatorNameFilter);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getReplicatorNameFilter() != null)
            sb.append("ReplicatorNameFilter: ").append(getReplicatorNameFilter());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListReplicatorsRequest == false)
            return false;
        ListReplicatorsRequest other = (ListReplicatorsRequest) obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getReplicatorNameFilter() == null ^ this.getReplicatorNameFilter() == null)
            return false;
        if (other.getReplicatorNameFilter() != null && other.getReplicatorNameFilter().equals(this.getReplicatorNameFilter()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getReplicatorNameFilter() == null) ? 0 : getReplicatorNameFilter().hashCode());
        return hashCode;
    }

    @Override
    public ListReplicatorsRequest clone() {
        return (ListReplicatorsRequest) super.clone();
    }

}
