/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.AttributeFilter;
import com.amazonaws.services.kendra.model.Facet;
import com.amazonaws.services.kendra.model.QueryResultType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QueryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private String queryText;
    private AttributeFilter attributeFilter;
    private List<Facet> facets;
    private List<String> requestedDocumentAttributes;
    private String queryResultTypeFilter;
    private Integer pageNumber;
    private Integer pageSize;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public QueryRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public QueryRequest withQueryText(String queryText) {
        this.setQueryText(queryText);
        return this;
    }

    public void setAttributeFilter(AttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    public AttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    public QueryRequest withAttributeFilter(AttributeFilter attributeFilter) {
        this.setAttributeFilter(attributeFilter);
        return this;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(Collection<Facet> facets) {
        if (facets == null) {
            this.facets = null;
            return;
        }
        this.facets = new ArrayList<Facet>(facets);
    }

    public QueryRequest withFacets(Facet ... facets) {
        if (this.facets == null) {
            this.setFacets(new ArrayList<Facet>(facets.length));
        }
        for (Facet ele : facets) {
            this.facets.add(ele);
        }
        return this;
    }

    public QueryRequest withFacets(Collection<Facet> facets) {
        this.setFacets(facets);
        return this;
    }

    public List<String> getRequestedDocumentAttributes() {
        return this.requestedDocumentAttributes;
    }

    public void setRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        if (requestedDocumentAttributes == null) {
            this.requestedDocumentAttributes = null;
            return;
        }
        this.requestedDocumentAttributes = new ArrayList<String>(requestedDocumentAttributes);
    }

    public QueryRequest withRequestedDocumentAttributes(String ... requestedDocumentAttributes) {
        if (this.requestedDocumentAttributes == null) {
            this.setRequestedDocumentAttributes(new ArrayList<String>(requestedDocumentAttributes.length));
        }
        for (String ele : requestedDocumentAttributes) {
            this.requestedDocumentAttributes.add(ele);
        }
        return this;
    }

    public QueryRequest withRequestedDocumentAttributes(Collection<String> requestedDocumentAttributes) {
        this.setRequestedDocumentAttributes(requestedDocumentAttributes);
        return this;
    }

    public void setQueryResultTypeFilter(String queryResultTypeFilter) {
        this.queryResultTypeFilter = queryResultTypeFilter;
    }

    public String getQueryResultTypeFilter() {
        return this.queryResultTypeFilter;
    }

    public QueryRequest withQueryResultTypeFilter(String queryResultTypeFilter) {
        this.setQueryResultTypeFilter(queryResultTypeFilter);
        return this;
    }

    public QueryRequest withQueryResultTypeFilter(QueryResultType queryResultTypeFilter) {
        this.queryResultTypeFilter = queryResultTypeFilter.toString();
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public QueryRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public QueryRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getQueryText() != null) {
            sb.append("QueryText: ").append(this.getQueryText()).append(",");
        }
        if (this.getAttributeFilter() != null) {
            sb.append("AttributeFilter: ").append(this.getAttributeFilter()).append(",");
        }
        if (this.getFacets() != null) {
            sb.append("Facets: ").append(this.getFacets()).append(",");
        }
        if (this.getRequestedDocumentAttributes() != null) {
            sb.append("RequestedDocumentAttributes: ").append(this.getRequestedDocumentAttributes()).append(",");
        }
        if (this.getQueryResultTypeFilter() != null) {
            sb.append("QueryResultTypeFilter: ").append(this.getQueryResultTypeFilter()).append(",");
        }
        if (this.getPageNumber() != null) {
            sb.append("PageNumber: ").append(this.getPageNumber()).append(",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getQueryText() == null ^ this.getQueryText() == null) {
            return false;
        }
        if (other.getQueryText() != null && !other.getQueryText().equals(this.getQueryText())) {
            return false;
        }
        if (other.getAttributeFilter() == null ^ this.getAttributeFilter() == null) {
            return false;
        }
        if (other.getAttributeFilter() != null && !other.getAttributeFilter().equals(this.getAttributeFilter())) {
            return false;
        }
        if (other.getFacets() == null ^ this.getFacets() == null) {
            return false;
        }
        if (other.getFacets() != null && !other.getFacets().equals(this.getFacets())) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() == null ^ this.getRequestedDocumentAttributes() == null) {
            return false;
        }
        if (other.getRequestedDocumentAttributes() != null && !other.getRequestedDocumentAttributes().equals(this.getRequestedDocumentAttributes())) {
            return false;
        }
        if (other.getQueryResultTypeFilter() == null ^ this.getQueryResultTypeFilter() == null) {
            return false;
        }
        if (other.getQueryResultTypeFilter() != null && !other.getQueryResultTypeFilter().equals(this.getQueryResultTypeFilter())) {
            return false;
        }
        if (other.getPageNumber() == null ^ this.getPageNumber() == null) {
            return false;
        }
        if (other.getPageNumber() != null && !other.getPageNumber().equals(this.getPageNumber())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        return other.getPageSize() == null || other.getPageSize().equals(this.getPageSize());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getQueryText() == null ? 0 : this.getQueryText().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeFilter() == null ? 0 : this.getAttributeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getFacets() == null ? 0 : this.getFacets().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedDocumentAttributes() == null ? 0 : this.getRequestedDocumentAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getQueryResultTypeFilter() == null ? 0 : this.getQueryResultTypeFilter().hashCode());
        hashCode = 31 * hashCode + (this.getPageNumber() == null ? 0 : this.getPageNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        return hashCode;
    }

    public QueryRequest clone() {
        return (QueryRequest)super.clone();
    }
}

