/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.AlfrescoEntity;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.S3Path;
import com.amazonaws.services.kendra.model.transform.AlfrescoConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AlfrescoConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String siteUrl;
    private String siteId;
    private String secretArn;
    private S3Path sslCertificateS3Path;
    private Boolean crawlSystemFolders;
    private Boolean crawlComments;
    private List<String> entityFilter;
    private List<DataSourceToIndexFieldMapping> documentLibraryFieldMappings;
    private List<DataSourceToIndexFieldMapping> blogFieldMappings;
    private List<DataSourceToIndexFieldMapping> wikiFieldMappings;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private DataSourceVpcConfiguration vpcConfiguration;

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public AlfrescoConfiguration withSiteUrl(String siteUrl) {
        this.setSiteUrl(siteUrl);
        return this;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public AlfrescoConfiguration withSiteId(String siteId) {
        this.setSiteId(siteId);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public AlfrescoConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public void setSslCertificateS3Path(S3Path sslCertificateS3Path) {
        this.sslCertificateS3Path = sslCertificateS3Path;
    }

    public S3Path getSslCertificateS3Path() {
        return this.sslCertificateS3Path;
    }

    public AlfrescoConfiguration withSslCertificateS3Path(S3Path sslCertificateS3Path) {
        this.setSslCertificateS3Path(sslCertificateS3Path);
        return this;
    }

    public void setCrawlSystemFolders(Boolean crawlSystemFolders) {
        this.crawlSystemFolders = crawlSystemFolders;
    }

    public Boolean getCrawlSystemFolders() {
        return this.crawlSystemFolders;
    }

    public AlfrescoConfiguration withCrawlSystemFolders(Boolean crawlSystemFolders) {
        this.setCrawlSystemFolders(crawlSystemFolders);
        return this;
    }

    public Boolean isCrawlSystemFolders() {
        return this.crawlSystemFolders;
    }

    public void setCrawlComments(Boolean crawlComments) {
        this.crawlComments = crawlComments;
    }

    public Boolean getCrawlComments() {
        return this.crawlComments;
    }

    public AlfrescoConfiguration withCrawlComments(Boolean crawlComments) {
        this.setCrawlComments(crawlComments);
        return this;
    }

    public Boolean isCrawlComments() {
        return this.crawlComments;
    }

    public List<String> getEntityFilter() {
        return this.entityFilter;
    }

    public void setEntityFilter(Collection<String> entityFilter) {
        if (entityFilter == null) {
            this.entityFilter = null;
            return;
        }
        this.entityFilter = new ArrayList<String>(entityFilter);
    }

    public AlfrescoConfiguration withEntityFilter(String ... entityFilter) {
        if (this.entityFilter == null) {
            this.setEntityFilter(new ArrayList<String>(entityFilter.length));
        }
        for (String ele : entityFilter) {
            this.entityFilter.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withEntityFilter(Collection<String> entityFilter) {
        this.setEntityFilter(entityFilter);
        return this;
    }

    public AlfrescoConfiguration withEntityFilter(AlfrescoEntity ... entityFilter) {
        ArrayList<String> entityFilterCopy = new ArrayList<String>(entityFilter.length);
        for (AlfrescoEntity value : entityFilter) {
            entityFilterCopy.add(value.toString());
        }
        if (this.getEntityFilter() == null) {
            this.setEntityFilter(entityFilterCopy);
        } else {
            this.getEntityFilter().addAll(entityFilterCopy);
        }
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getDocumentLibraryFieldMappings() {
        return this.documentLibraryFieldMappings;
    }

    public void setDocumentLibraryFieldMappings(Collection<DataSourceToIndexFieldMapping> documentLibraryFieldMappings) {
        if (documentLibraryFieldMappings == null) {
            this.documentLibraryFieldMappings = null;
            return;
        }
        this.documentLibraryFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(documentLibraryFieldMappings);
    }

    public AlfrescoConfiguration withDocumentLibraryFieldMappings(DataSourceToIndexFieldMapping ... documentLibraryFieldMappings) {
        if (this.documentLibraryFieldMappings == null) {
            this.setDocumentLibraryFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(documentLibraryFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : documentLibraryFieldMappings) {
            this.documentLibraryFieldMappings.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withDocumentLibraryFieldMappings(Collection<DataSourceToIndexFieldMapping> documentLibraryFieldMappings) {
        this.setDocumentLibraryFieldMappings(documentLibraryFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getBlogFieldMappings() {
        return this.blogFieldMappings;
    }

    public void setBlogFieldMappings(Collection<DataSourceToIndexFieldMapping> blogFieldMappings) {
        if (blogFieldMappings == null) {
            this.blogFieldMappings = null;
            return;
        }
        this.blogFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(blogFieldMappings);
    }

    public AlfrescoConfiguration withBlogFieldMappings(DataSourceToIndexFieldMapping ... blogFieldMappings) {
        if (this.blogFieldMappings == null) {
            this.setBlogFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(blogFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : blogFieldMappings) {
            this.blogFieldMappings.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withBlogFieldMappings(Collection<DataSourceToIndexFieldMapping> blogFieldMappings) {
        this.setBlogFieldMappings(blogFieldMappings);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getWikiFieldMappings() {
        return this.wikiFieldMappings;
    }

    public void setWikiFieldMappings(Collection<DataSourceToIndexFieldMapping> wikiFieldMappings) {
        if (wikiFieldMappings == null) {
            this.wikiFieldMappings = null;
            return;
        }
        this.wikiFieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(wikiFieldMappings);
    }

    public AlfrescoConfiguration withWikiFieldMappings(DataSourceToIndexFieldMapping ... wikiFieldMappings) {
        if (this.wikiFieldMappings == null) {
            this.setWikiFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(wikiFieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : wikiFieldMappings) {
            this.wikiFieldMappings.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withWikiFieldMappings(Collection<DataSourceToIndexFieldMapping> wikiFieldMappings) {
        this.setWikiFieldMappings(wikiFieldMappings);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public AlfrescoConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public AlfrescoConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public AlfrescoConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public AlfrescoConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSiteUrl() != null) {
            sb.append("SiteUrl: ").append(this.getSiteUrl()).append(",");
        }
        if (this.getSiteId() != null) {
            sb.append("SiteId: ").append(this.getSiteId()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getSslCertificateS3Path() != null) {
            sb.append("SslCertificateS3Path: ").append(this.getSslCertificateS3Path()).append(",");
        }
        if (this.getCrawlSystemFolders() != null) {
            sb.append("CrawlSystemFolders: ").append(this.getCrawlSystemFolders()).append(",");
        }
        if (this.getCrawlComments() != null) {
            sb.append("CrawlComments: ").append(this.getCrawlComments()).append(",");
        }
        if (this.getEntityFilter() != null) {
            sb.append("EntityFilter: ").append(this.getEntityFilter()).append(",");
        }
        if (this.getDocumentLibraryFieldMappings() != null) {
            sb.append("DocumentLibraryFieldMappings: ").append(this.getDocumentLibraryFieldMappings()).append(",");
        }
        if (this.getBlogFieldMappings() != null) {
            sb.append("BlogFieldMappings: ").append(this.getBlogFieldMappings()).append(",");
        }
        if (this.getWikiFieldMappings() != null) {
            sb.append("WikiFieldMappings: ").append(this.getWikiFieldMappings()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlfrescoConfiguration)) {
            return false;
        }
        AlfrescoConfiguration other = (AlfrescoConfiguration)obj;
        if (other.getSiteUrl() == null ^ this.getSiteUrl() == null) {
            return false;
        }
        if (other.getSiteUrl() != null && !other.getSiteUrl().equals(this.getSiteUrl())) {
            return false;
        }
        if (other.getSiteId() == null ^ this.getSiteId() == null) {
            return false;
        }
        if (other.getSiteId() != null && !other.getSiteId().equals(this.getSiteId())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getSslCertificateS3Path() == null ^ this.getSslCertificateS3Path() == null) {
            return false;
        }
        if (other.getSslCertificateS3Path() != null && !other.getSslCertificateS3Path().equals(this.getSslCertificateS3Path())) {
            return false;
        }
        if (other.getCrawlSystemFolders() == null ^ this.getCrawlSystemFolders() == null) {
            return false;
        }
        if (other.getCrawlSystemFolders() != null && !other.getCrawlSystemFolders().equals(this.getCrawlSystemFolders())) {
            return false;
        }
        if (other.getCrawlComments() == null ^ this.getCrawlComments() == null) {
            return false;
        }
        if (other.getCrawlComments() != null && !other.getCrawlComments().equals(this.getCrawlComments())) {
            return false;
        }
        if (other.getEntityFilter() == null ^ this.getEntityFilter() == null) {
            return false;
        }
        if (other.getEntityFilter() != null && !other.getEntityFilter().equals(this.getEntityFilter())) {
            return false;
        }
        if (other.getDocumentLibraryFieldMappings() == null ^ this.getDocumentLibraryFieldMappings() == null) {
            return false;
        }
        if (other.getDocumentLibraryFieldMappings() != null && !other.getDocumentLibraryFieldMappings().equals(this.getDocumentLibraryFieldMappings())) {
            return false;
        }
        if (other.getBlogFieldMappings() == null ^ this.getBlogFieldMappings() == null) {
            return false;
        }
        if (other.getBlogFieldMappings() != null && !other.getBlogFieldMappings().equals(this.getBlogFieldMappings())) {
            return false;
        }
        if (other.getWikiFieldMappings() == null ^ this.getWikiFieldMappings() == null) {
            return false;
        }
        if (other.getWikiFieldMappings() != null && !other.getWikiFieldMappings().equals(this.getWikiFieldMappings())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        return other.getVpcConfiguration() == null || other.getVpcConfiguration().equals(this.getVpcConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSiteUrl() == null ? 0 : this.getSiteUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSiteId() == null ? 0 : this.getSiteId().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getSslCertificateS3Path() == null ? 0 : this.getSslCertificateS3Path().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlSystemFolders() == null ? 0 : this.getCrawlSystemFolders().hashCode());
        hashCode = 31 * hashCode + (this.getCrawlComments() == null ? 0 : this.getCrawlComments().hashCode());
        hashCode = 31 * hashCode + (this.getEntityFilter() == null ? 0 : this.getEntityFilter().hashCode());
        hashCode = 31 * hashCode + (this.getDocumentLibraryFieldMappings() == null ? 0 : this.getDocumentLibraryFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getBlogFieldMappings() == null ? 0 : this.getBlogFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getWikiFieldMappings() == null ? 0 : this.getWikiFieldMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        return hashCode;
    }

    public AlfrescoConfiguration clone() {
        try {
            return (AlfrescoConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlfrescoConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

