/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendraranking;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kendraranking.AmazonKendraRankingAsync;
import com.amazonaws.services.kendraranking.AmazonKendraRankingAsyncClientBuilder;
import com.amazonaws.services.kendraranking.AmazonKendraRankingClient;
import com.amazonaws.services.kendraranking.model.CreateRescoreExecutionPlanRequest;
import com.amazonaws.services.kendraranking.model.CreateRescoreExecutionPlanResult;
import com.amazonaws.services.kendraranking.model.DeleteRescoreExecutionPlanRequest;
import com.amazonaws.services.kendraranking.model.DeleteRescoreExecutionPlanResult;
import com.amazonaws.services.kendraranking.model.DescribeRescoreExecutionPlanRequest;
import com.amazonaws.services.kendraranking.model.DescribeRescoreExecutionPlanResult;
import com.amazonaws.services.kendraranking.model.ListRescoreExecutionPlansRequest;
import com.amazonaws.services.kendraranking.model.ListRescoreExecutionPlansResult;
import com.amazonaws.services.kendraranking.model.ListTagsForResourceRequest;
import com.amazonaws.services.kendraranking.model.ListTagsForResourceResult;
import com.amazonaws.services.kendraranking.model.RescoreRequest;
import com.amazonaws.services.kendraranking.model.RescoreResult;
import com.amazonaws.services.kendraranking.model.TagResourceRequest;
import com.amazonaws.services.kendraranking.model.TagResourceResult;
import com.amazonaws.services.kendraranking.model.UntagResourceRequest;
import com.amazonaws.services.kendraranking.model.UntagResourceResult;
import com.amazonaws.services.kendraranking.model.UpdateRescoreExecutionPlanRequest;
import com.amazonaws.services.kendraranking.model.UpdateRescoreExecutionPlanResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKendraRankingAsyncClient
extends AmazonKendraRankingClient
implements AmazonKendraRankingAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKendraRankingAsyncClientBuilder asyncBuilder() {
        return AmazonKendraRankingAsyncClientBuilder.standard();
    }

    AmazonKendraRankingAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonKendraRankingAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateRescoreExecutionPlanResult> createRescoreExecutionPlanAsync(CreateRescoreExecutionPlanRequest request) {
        return this.createRescoreExecutionPlanAsync(request, null);
    }

    @Override
    public Future<CreateRescoreExecutionPlanResult> createRescoreExecutionPlanAsync(CreateRescoreExecutionPlanRequest request, final AsyncHandler<CreateRescoreExecutionPlanRequest, CreateRescoreExecutionPlanResult> asyncHandler) {
        final CreateRescoreExecutionPlanRequest finalRequest = (CreateRescoreExecutionPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRescoreExecutionPlanResult>(){

            @Override
            public CreateRescoreExecutionPlanResult call() throws Exception {
                CreateRescoreExecutionPlanResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeCreateRescoreExecutionPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRescoreExecutionPlanResult> deleteRescoreExecutionPlanAsync(DeleteRescoreExecutionPlanRequest request) {
        return this.deleteRescoreExecutionPlanAsync(request, null);
    }

    @Override
    public Future<DeleteRescoreExecutionPlanResult> deleteRescoreExecutionPlanAsync(DeleteRescoreExecutionPlanRequest request, final AsyncHandler<DeleteRescoreExecutionPlanRequest, DeleteRescoreExecutionPlanResult> asyncHandler) {
        final DeleteRescoreExecutionPlanRequest finalRequest = (DeleteRescoreExecutionPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRescoreExecutionPlanResult>(){

            @Override
            public DeleteRescoreExecutionPlanResult call() throws Exception {
                DeleteRescoreExecutionPlanResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeDeleteRescoreExecutionPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRescoreExecutionPlanResult> describeRescoreExecutionPlanAsync(DescribeRescoreExecutionPlanRequest request) {
        return this.describeRescoreExecutionPlanAsync(request, null);
    }

    @Override
    public Future<DescribeRescoreExecutionPlanResult> describeRescoreExecutionPlanAsync(DescribeRescoreExecutionPlanRequest request, final AsyncHandler<DescribeRescoreExecutionPlanRequest, DescribeRescoreExecutionPlanResult> asyncHandler) {
        final DescribeRescoreExecutionPlanRequest finalRequest = (DescribeRescoreExecutionPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeRescoreExecutionPlanResult>(){

            @Override
            public DescribeRescoreExecutionPlanResult call() throws Exception {
                DescribeRescoreExecutionPlanResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeDescribeRescoreExecutionPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRescoreExecutionPlansResult> listRescoreExecutionPlansAsync(ListRescoreExecutionPlansRequest request) {
        return this.listRescoreExecutionPlansAsync(request, null);
    }

    @Override
    public Future<ListRescoreExecutionPlansResult> listRescoreExecutionPlansAsync(ListRescoreExecutionPlansRequest request, final AsyncHandler<ListRescoreExecutionPlansRequest, ListRescoreExecutionPlansResult> asyncHandler) {
        final ListRescoreExecutionPlansRequest finalRequest = (ListRescoreExecutionPlansRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRescoreExecutionPlansResult>(){

            @Override
            public ListRescoreExecutionPlansResult call() throws Exception {
                ListRescoreExecutionPlansResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeListRescoreExecutionPlans(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RescoreResult> rescoreAsync(RescoreRequest request) {
        return this.rescoreAsync(request, null);
    }

    @Override
    public Future<RescoreResult> rescoreAsync(RescoreRequest request, final AsyncHandler<RescoreRequest, RescoreResult> asyncHandler) {
        final RescoreRequest finalRequest = (RescoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RescoreResult>(){

            @Override
            public RescoreResult call() throws Exception {
                RescoreResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeRescore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRescoreExecutionPlanResult> updateRescoreExecutionPlanAsync(UpdateRescoreExecutionPlanRequest request) {
        return this.updateRescoreExecutionPlanAsync(request, null);
    }

    @Override
    public Future<UpdateRescoreExecutionPlanResult> updateRescoreExecutionPlanAsync(UpdateRescoreExecutionPlanRequest request, final AsyncHandler<UpdateRescoreExecutionPlanRequest, UpdateRescoreExecutionPlanResult> asyncHandler) {
        final UpdateRescoreExecutionPlanRequest finalRequest = (UpdateRescoreExecutionPlanRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRescoreExecutionPlanResult>(){

            @Override
            public UpdateRescoreExecutionPlanResult call() throws Exception {
                UpdateRescoreExecutionPlanResult result = null;
                try {
                    result = AmazonKendraRankingAsyncClient.this.executeUpdateRescoreExecutionPlan(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

