/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.CodeContentDescription;

@SdkInternalApi
public class CodeContentDescriptionMarshaller {
    private static final MarshallingInfo<String> TEXTCONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextContent").build();
    private static final MarshallingInfo<String> CODEMD5_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeMD5").build();
    private static final MarshallingInfo<Long> CODESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeSize").build();
    private static final MarshallingInfo<StructuredPojo> S3APPLICATIONCODELOCATIONDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3ApplicationCodeLocationDescription").build();
    private static final CodeContentDescriptionMarshaller instance = new CodeContentDescriptionMarshaller();

    public static CodeContentDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeContentDescription codeContentDescription, ProtocolMarshaller protocolMarshaller) {
        if (codeContentDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeContentDescription.getTextContent(), TEXTCONTENT_BINDING);
            protocolMarshaller.marshall((Object)codeContentDescription.getCodeMD5(), CODEMD5_BINDING);
            protocolMarshaller.marshall((Object)codeContentDescription.getCodeSize(), CODESIZE_BINDING);
            protocolMarshaller.marshall((Object)codeContentDescription.getS3ApplicationCodeLocationDescription(), S3APPLICATIONCODELOCATIONDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

