/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TagStreamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String streamARN;
    private String streamName;
    private Map<String, String> tags;

    public void setStreamARN(String streamARN) {
        this.streamARN = streamARN;
    }

    public String getStreamARN() {
        return this.streamARN;
    }

    public TagStreamRequest withStreamARN(String streamARN) {
        this.setStreamARN(streamARN);
        return this;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public TagStreamRequest withStreamName(String streamName) {
        this.setStreamName(streamName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public TagStreamRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public TagStreamRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public TagStreamRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamARN() != null) {
            sb.append("StreamARN: ").append(this.getStreamARN()).append(",");
        }
        if (this.getStreamName() != null) {
            sb.append("StreamName: ").append(this.getStreamName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagStreamRequest)) {
            return false;
        }
        TagStreamRequest other = (TagStreamRequest)obj;
        if (other.getStreamARN() == null ^ this.getStreamARN() == null) {
            return false;
        }
        if (other.getStreamARN() != null && !other.getStreamARN().equals(this.getStreamARN())) {
            return false;
        }
        if (other.getStreamName() == null ^ this.getStreamName() == null) {
            return false;
        }
        if (other.getStreamName() != null && !other.getStreamName().equals(this.getStreamName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamARN() == null ? 0 : this.getStreamARN().hashCode());
        hashCode = 31 * hashCode + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public TagStreamRequest clone() {
        return (TagStreamRequest)super.clone();
    }
}

