/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoAsync;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoAsyncClientBuilder;
import com.amazonaws.services.kinesisvideo.AmazonKinesisVideoClient;
import com.amazonaws.services.kinesisvideo.model.CreateSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.CreateSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.CreateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.CreateStreamResult;
import com.amazonaws.services.kinesisvideo.model.DeleteSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DeleteStreamResult;
import com.amazonaws.services.kinesisvideo.model.DescribeSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamRequest;
import com.amazonaws.services.kinesisvideo.model.DescribeStreamResult;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetDataEndpointResult;
import com.amazonaws.services.kinesisvideo.model.GetSignalingChannelEndpointRequest;
import com.amazonaws.services.kinesisvideo.model.GetSignalingChannelEndpointResult;
import com.amazonaws.services.kinesisvideo.model.ListSignalingChannelsRequest;
import com.amazonaws.services.kinesisvideo.model.ListSignalingChannelsResult;
import com.amazonaws.services.kinesisvideo.model.ListStreamsRequest;
import com.amazonaws.services.kinesisvideo.model.ListStreamsResult;
import com.amazonaws.services.kinesisvideo.model.ListTagsForResourceRequest;
import com.amazonaws.services.kinesisvideo.model.ListTagsForResourceResult;
import com.amazonaws.services.kinesisvideo.model.ListTagsForStreamRequest;
import com.amazonaws.services.kinesisvideo.model.ListTagsForStreamResult;
import com.amazonaws.services.kinesisvideo.model.TagResourceRequest;
import com.amazonaws.services.kinesisvideo.model.TagResourceResult;
import com.amazonaws.services.kinesisvideo.model.TagStreamRequest;
import com.amazonaws.services.kinesisvideo.model.TagStreamResult;
import com.amazonaws.services.kinesisvideo.model.UntagResourceRequest;
import com.amazonaws.services.kinesisvideo.model.UntagResourceResult;
import com.amazonaws.services.kinesisvideo.model.UntagStreamRequest;
import com.amazonaws.services.kinesisvideo.model.UntagStreamResult;
import com.amazonaws.services.kinesisvideo.model.UpdateDataRetentionRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateDataRetentionResult;
import com.amazonaws.services.kinesisvideo.model.UpdateSignalingChannelRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateSignalingChannelResult;
import com.amazonaws.services.kinesisvideo.model.UpdateStreamRequest;
import com.amazonaws.services.kinesisvideo.model.UpdateStreamResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonKinesisVideoAsyncClient
extends AmazonKinesisVideoClient
implements AmazonKinesisVideoAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonKinesisVideoAsyncClientBuilder asyncBuilder() {
        return AmazonKinesisVideoAsyncClientBuilder.standard();
    }

    AmazonKinesisVideoAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateSignalingChannelResult> createSignalingChannelAsync(CreateSignalingChannelRequest request) {
        return this.createSignalingChannelAsync(request, null);
    }

    @Override
    public Future<CreateSignalingChannelResult> createSignalingChannelAsync(CreateSignalingChannelRequest request, final AsyncHandler<CreateSignalingChannelRequest, CreateSignalingChannelResult> asyncHandler) {
        final CreateSignalingChannelRequest finalRequest = (CreateSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSignalingChannelResult>(){

            @Override
            public CreateSignalingChannelResult call() throws Exception {
                CreateSignalingChannelResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeCreateSignalingChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(CreateStreamRequest request) {
        return this.createStreamAsync(request, null);
    }

    @Override
    public Future<CreateStreamResult> createStreamAsync(CreateStreamRequest request, final AsyncHandler<CreateStreamRequest, CreateStreamResult> asyncHandler) {
        final CreateStreamRequest finalRequest = (CreateStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamResult>(){

            @Override
            public CreateStreamResult call() throws Exception {
                CreateStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeCreateStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSignalingChannelResult> deleteSignalingChannelAsync(DeleteSignalingChannelRequest request) {
        return this.deleteSignalingChannelAsync(request, null);
    }

    @Override
    public Future<DeleteSignalingChannelResult> deleteSignalingChannelAsync(DeleteSignalingChannelRequest request, final AsyncHandler<DeleteSignalingChannelRequest, DeleteSignalingChannelResult> asyncHandler) {
        final DeleteSignalingChannelRequest finalRequest = (DeleteSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSignalingChannelResult>(){

            @Override
            public DeleteSignalingChannelResult call() throws Exception {
                DeleteSignalingChannelResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeDeleteSignalingChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(DeleteStreamRequest request) {
        return this.deleteStreamAsync(request, null);
    }

    @Override
    public Future<DeleteStreamResult> deleteStreamAsync(DeleteStreamRequest request, final AsyncHandler<DeleteStreamRequest, DeleteStreamResult> asyncHandler) {
        final DeleteStreamRequest finalRequest = (DeleteStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStreamResult>(){

            @Override
            public DeleteStreamResult call() throws Exception {
                DeleteStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeDeleteStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSignalingChannelResult> describeSignalingChannelAsync(DescribeSignalingChannelRequest request) {
        return this.describeSignalingChannelAsync(request, null);
    }

    @Override
    public Future<DescribeSignalingChannelResult> describeSignalingChannelAsync(DescribeSignalingChannelRequest request, final AsyncHandler<DescribeSignalingChannelRequest, DescribeSignalingChannelResult> asyncHandler) {
        final DescribeSignalingChannelRequest finalRequest = (DescribeSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSignalingChannelResult>(){

            @Override
            public DescribeSignalingChannelResult call() throws Exception {
                DescribeSignalingChannelResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeDescribeSignalingChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request) {
        return this.describeStreamAsync(request, null);
    }

    @Override
    public Future<DescribeStreamResult> describeStreamAsync(DescribeStreamRequest request, final AsyncHandler<DescribeStreamRequest, DescribeStreamResult> asyncHandler) {
        final DescribeStreamRequest finalRequest = (DescribeStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStreamResult>(){

            @Override
            public DescribeStreamResult call() throws Exception {
                DescribeStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeDescribeStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataEndpointResult> getDataEndpointAsync(GetDataEndpointRequest request) {
        return this.getDataEndpointAsync(request, null);
    }

    @Override
    public Future<GetDataEndpointResult> getDataEndpointAsync(GetDataEndpointRequest request, final AsyncHandler<GetDataEndpointRequest, GetDataEndpointResult> asyncHandler) {
        final GetDataEndpointRequest finalRequest = (GetDataEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataEndpointResult>(){

            @Override
            public GetDataEndpointResult call() throws Exception {
                GetDataEndpointResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeGetDataEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSignalingChannelEndpointResult> getSignalingChannelEndpointAsync(GetSignalingChannelEndpointRequest request) {
        return this.getSignalingChannelEndpointAsync(request, null);
    }

    @Override
    public Future<GetSignalingChannelEndpointResult> getSignalingChannelEndpointAsync(GetSignalingChannelEndpointRequest request, final AsyncHandler<GetSignalingChannelEndpointRequest, GetSignalingChannelEndpointResult> asyncHandler) {
        final GetSignalingChannelEndpointRequest finalRequest = (GetSignalingChannelEndpointRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSignalingChannelEndpointResult>(){

            @Override
            public GetSignalingChannelEndpointResult call() throws Exception {
                GetSignalingChannelEndpointResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeGetSignalingChannelEndpoint(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSignalingChannelsResult> listSignalingChannelsAsync(ListSignalingChannelsRequest request) {
        return this.listSignalingChannelsAsync(request, null);
    }

    @Override
    public Future<ListSignalingChannelsResult> listSignalingChannelsAsync(ListSignalingChannelsRequest request, final AsyncHandler<ListSignalingChannelsRequest, ListSignalingChannelsResult> asyncHandler) {
        final ListSignalingChannelsRequest finalRequest = (ListSignalingChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSignalingChannelsResult>(){

            @Override
            public ListSignalingChannelsResult call() throws Exception {
                ListSignalingChannelsResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeListSignalingChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request) {
        return this.listStreamsAsync(request, null);
    }

    @Override
    public Future<ListStreamsResult> listStreamsAsync(ListStreamsRequest request, final AsyncHandler<ListStreamsRequest, ListStreamsResult> asyncHandler) {
        final ListStreamsRequest finalRequest = (ListStreamsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStreamsResult>(){

            @Override
            public ListStreamsResult call() throws Exception {
                ListStreamsResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeListStreams(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(ListTagsForStreamRequest request) {
        return this.listTagsForStreamAsync(request, null);
    }

    @Override
    public Future<ListTagsForStreamResult> listTagsForStreamAsync(ListTagsForStreamRequest request, final AsyncHandler<ListTagsForStreamRequest, ListTagsForStreamResult> asyncHandler) {
        final ListTagsForStreamRequest finalRequest = (ListTagsForStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForStreamResult>(){

            @Override
            public ListTagsForStreamResult call() throws Exception {
                ListTagsForStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeListTagsForStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagStreamResult> tagStreamAsync(TagStreamRequest request) {
        return this.tagStreamAsync(request, null);
    }

    @Override
    public Future<TagStreamResult> tagStreamAsync(TagStreamRequest request, final AsyncHandler<TagStreamRequest, TagStreamResult> asyncHandler) {
        final TagStreamRequest finalRequest = (TagStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagStreamResult>(){

            @Override
            public TagStreamResult call() throws Exception {
                TagStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeTagStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagStreamResult> untagStreamAsync(UntagStreamRequest request) {
        return this.untagStreamAsync(request, null);
    }

    @Override
    public Future<UntagStreamResult> untagStreamAsync(UntagStreamRequest request, final AsyncHandler<UntagStreamRequest, UntagStreamResult> asyncHandler) {
        final UntagStreamRequest finalRequest = (UntagStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagStreamResult>(){

            @Override
            public UntagStreamResult call() throws Exception {
                UntagStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeUntagStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataRetentionResult> updateDataRetentionAsync(UpdateDataRetentionRequest request) {
        return this.updateDataRetentionAsync(request, null);
    }

    @Override
    public Future<UpdateDataRetentionResult> updateDataRetentionAsync(UpdateDataRetentionRequest request, final AsyncHandler<UpdateDataRetentionRequest, UpdateDataRetentionResult> asyncHandler) {
        final UpdateDataRetentionRequest finalRequest = (UpdateDataRetentionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataRetentionResult>(){

            @Override
            public UpdateDataRetentionResult call() throws Exception {
                UpdateDataRetentionResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeUpdateDataRetention(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSignalingChannelResult> updateSignalingChannelAsync(UpdateSignalingChannelRequest request) {
        return this.updateSignalingChannelAsync(request, null);
    }

    @Override
    public Future<UpdateSignalingChannelResult> updateSignalingChannelAsync(UpdateSignalingChannelRequest request, final AsyncHandler<UpdateSignalingChannelRequest, UpdateSignalingChannelResult> asyncHandler) {
        final UpdateSignalingChannelRequest finalRequest = (UpdateSignalingChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSignalingChannelResult>(){

            @Override
            public UpdateSignalingChannelResult call() throws Exception {
                UpdateSignalingChannelResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeUpdateSignalingChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStreamResult> updateStreamAsync(UpdateStreamRequest request) {
        return this.updateStreamAsync(request, null);
    }

    @Override
    public Future<UpdateStreamResult> updateStreamAsync(UpdateStreamRequest request, final AsyncHandler<UpdateStreamRequest, UpdateStreamResult> asyncHandler) {
        final UpdateStreamRequest finalRequest = (UpdateStreamRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStreamResult>(){

            @Override
            public UpdateStreamResult call() throws Exception {
                UpdateStreamResult result = null;
                try {
                    result = AmazonKinesisVideoAsyncClient.this.executeUpdateStream(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

