/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisvideo.model.ImageError;
import com.amazonaws.services.kinesisvideo.model.transform.ImageMarshaller;
import java.io.Serializable;
import java.util.Date;

public class Image
implements Serializable,
Cloneable,
StructuredPojo {
    private Date timeStamp;
    private String error;
    private String imageContent;

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public Image withTimeStamp(Date timeStamp) {
        this.setTimeStamp(timeStamp);
        return this;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public Image withError(String error) {
        this.setError(error);
        return this;
    }

    public Image withError(ImageError error) {
        this.error = error.toString();
        return this;
    }

    public void setImageContent(String imageContent) {
        this.imageContent = imageContent;
    }

    public String getImageContent() {
        return this.imageContent;
    }

    public Image withImageContent(String imageContent) {
        this.setImageContent(imageContent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTimeStamp() != null) {
            sb.append("TimeStamp: ").append(this.getTimeStamp()).append(",");
        }
        if (this.getError() != null) {
            sb.append("Error: ").append(this.getError()).append(",");
        }
        if (this.getImageContent() != null) {
            sb.append("ImageContent: ").append(this.getImageContent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getTimeStamp() == null ^ this.getTimeStamp() == null) {
            return false;
        }
        if (other.getTimeStamp() != null && !other.getTimeStamp().equals(this.getTimeStamp())) {
            return false;
        }
        if (other.getError() == null ^ this.getError() == null) {
            return false;
        }
        if (other.getError() != null && !other.getError().equals(this.getError())) {
            return false;
        }
        if (other.getImageContent() == null ^ this.getImageContent() == null) {
            return false;
        }
        return other.getImageContent() == null || other.getImageContent().equals(this.getImageContent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTimeStamp() == null ? 0 : this.getTimeStamp().hashCode());
        hashCode = 31 * hashCode + (this.getError() == null ? 0 : this.getError().hashCode());
        hashCode = 31 * hashCode + (this.getImageContent() == null ? 0 : this.getImageContent().hashCode());
        return hashCode;
    }

    public Image clone() {
        try {
            return (Image)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

