/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsync;
import com.amazonaws.services.lakeformation.AWSLakeFormationAsyncClientBuilder;
import com.amazonaws.services.lakeformation.AWSLakeFormationClient;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchGrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.BatchRevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.DeregisterResourceRequest;
import com.amazonaws.services.lakeformation.model.DeregisterResourceResult;
import com.amazonaws.services.lakeformation.model.DescribeResourceRequest;
import com.amazonaws.services.lakeformation.model.DescribeResourceResult;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.GetDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import com.amazonaws.services.lakeformation.model.GetEffectivePermissionsForPathResult;
import com.amazonaws.services.lakeformation.model.GrantPermissionsRequest;
import com.amazonaws.services.lakeformation.model.GrantPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListPermissionsRequest;
import com.amazonaws.services.lakeformation.model.ListPermissionsResult;
import com.amazonaws.services.lakeformation.model.ListResourcesRequest;
import com.amazonaws.services.lakeformation.model.ListResourcesResult;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsRequest;
import com.amazonaws.services.lakeformation.model.PutDataLakeSettingsResult;
import com.amazonaws.services.lakeformation.model.RegisterResourceRequest;
import com.amazonaws.services.lakeformation.model.RegisterResourceResult;
import com.amazonaws.services.lakeformation.model.RevokePermissionsRequest;
import com.amazonaws.services.lakeformation.model.RevokePermissionsResult;
import com.amazonaws.services.lakeformation.model.UpdateResourceRequest;
import com.amazonaws.services.lakeformation.model.UpdateResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSLakeFormationAsyncClient
extends AWSLakeFormationClient
implements AWSLakeFormationAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSLakeFormationAsyncClientBuilder asyncBuilder() {
        return AWSLakeFormationAsyncClientBuilder.standard();
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSLakeFormationAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request) {
        return this.batchGrantPermissionsAsync(request, null);
    }

    @Override
    public Future<BatchGrantPermissionsResult> batchGrantPermissionsAsync(BatchGrantPermissionsRequest request, final AsyncHandler<BatchGrantPermissionsRequest, BatchGrantPermissionsResult> asyncHandler) {
        final BatchGrantPermissionsRequest finalRequest = (BatchGrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGrantPermissionsResult>(){

            @Override
            public BatchGrantPermissionsResult call() throws Exception {
                BatchGrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request) {
        return this.batchRevokePermissionsAsync(request, null);
    }

    @Override
    public Future<BatchRevokePermissionsResult> batchRevokePermissionsAsync(BatchRevokePermissionsRequest request, final AsyncHandler<BatchRevokePermissionsRequest, BatchRevokePermissionsResult> asyncHandler) {
        final BatchRevokePermissionsRequest finalRequest = (BatchRevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchRevokePermissionsResult>(){

            @Override
            public BatchRevokePermissionsResult call() throws Exception {
                BatchRevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeBatchRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request) {
        return this.deregisterResourceAsync(request, null);
    }

    @Override
    public Future<DeregisterResourceResult> deregisterResourceAsync(DeregisterResourceRequest request, final AsyncHandler<DeregisterResourceRequest, DeregisterResourceResult> asyncHandler) {
        final DeregisterResourceRequest finalRequest = (DeregisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterResourceResult>(){

            @Override
            public DeregisterResourceResult call() throws Exception {
                DeregisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDeregisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request) {
        return this.describeResourceAsync(request, null);
    }

    @Override
    public Future<DescribeResourceResult> describeResourceAsync(DescribeResourceRequest request, final AsyncHandler<DescribeResourceRequest, DescribeResourceResult> asyncHandler) {
        final DescribeResourceRequest finalRequest = (DescribeResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeResourceResult>(){

            @Override
            public DescribeResourceResult call() throws Exception {
                DescribeResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeDescribeResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request) {
        return this.getDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<GetDataLakeSettingsResult> getDataLakeSettingsAsync(GetDataLakeSettingsRequest request, final AsyncHandler<GetDataLakeSettingsRequest, GetDataLakeSettingsResult> asyncHandler) {
        final GetDataLakeSettingsRequest finalRequest = (GetDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDataLakeSettingsResult>(){

            @Override
            public GetDataLakeSettingsResult call() throws Exception {
                GetDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request) {
        return this.getEffectivePermissionsForPathAsync(request, null);
    }

    @Override
    public Future<GetEffectivePermissionsForPathResult> getEffectivePermissionsForPathAsync(GetEffectivePermissionsForPathRequest request, final AsyncHandler<GetEffectivePermissionsForPathRequest, GetEffectivePermissionsForPathResult> asyncHandler) {
        final GetEffectivePermissionsForPathRequest finalRequest = (GetEffectivePermissionsForPathRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEffectivePermissionsForPathResult>(){

            @Override
            public GetEffectivePermissionsForPathResult call() throws Exception {
                GetEffectivePermissionsForPathResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGetEffectivePermissionsForPath(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request) {
        return this.grantPermissionsAsync(request, null);
    }

    @Override
    public Future<GrantPermissionsResult> grantPermissionsAsync(GrantPermissionsRequest request, final AsyncHandler<GrantPermissionsRequest, GrantPermissionsResult> asyncHandler) {
        final GrantPermissionsRequest finalRequest = (GrantPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GrantPermissionsResult>(){

            @Override
            public GrantPermissionsResult call() throws Exception {
                GrantPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeGrantPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request) {
        return this.listPermissionsAsync(request, null);
    }

    @Override
    public Future<ListPermissionsResult> listPermissionsAsync(ListPermissionsRequest request, final AsyncHandler<ListPermissionsRequest, ListPermissionsResult> asyncHandler) {
        final ListPermissionsRequest finalRequest = (ListPermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPermissionsResult>(){

            @Override
            public ListPermissionsResult call() throws Exception {
                ListPermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListPermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = (ListResourcesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request) {
        return this.putDataLakeSettingsAsync(request, null);
    }

    @Override
    public Future<PutDataLakeSettingsResult> putDataLakeSettingsAsync(PutDataLakeSettingsRequest request, final AsyncHandler<PutDataLakeSettingsRequest, PutDataLakeSettingsResult> asyncHandler) {
        final PutDataLakeSettingsRequest finalRequest = (PutDataLakeSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutDataLakeSettingsResult>(){

            @Override
            public PutDataLakeSettingsResult call() throws Exception {
                PutDataLakeSettingsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executePutDataLakeSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request) {
        return this.registerResourceAsync(request, null);
    }

    @Override
    public Future<RegisterResourceResult> registerResourceAsync(RegisterResourceRequest request, final AsyncHandler<RegisterResourceRequest, RegisterResourceResult> asyncHandler) {
        final RegisterResourceRequest finalRequest = (RegisterResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterResourceResult>(){

            @Override
            public RegisterResourceResult call() throws Exception {
                RegisterResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRegisterResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request) {
        return this.revokePermissionsAsync(request, null);
    }

    @Override
    public Future<RevokePermissionsResult> revokePermissionsAsync(RevokePermissionsRequest request, final AsyncHandler<RevokePermissionsRequest, RevokePermissionsResult> asyncHandler) {
        final RevokePermissionsRequest finalRequest = (RevokePermissionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RevokePermissionsResult>(){

            @Override
            public RevokePermissionsResult call() throws Exception {
                RevokePermissionsResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeRevokePermissions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request) {
        return this.updateResourceAsync(request, null);
    }

    @Override
    public Future<UpdateResourceResult> updateResourceAsync(UpdateResourceRequest request, final AsyncHandler<UpdateResourceRequest, UpdateResourceResult> asyncHandler) {
        final UpdateResourceRequest finalRequest = (UpdateResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateResourceResult>(){

            @Override
            public UpdateResourceResult call() throws Exception {
                UpdateResourceResult result = null;
                try {
                    result = AWSLakeFormationAsyncClient.this.executeUpdateResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

