/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lakeformation.model.TableObject;
import com.amazonaws.services.lakeformation.model.transform.PartitionObjectsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PartitionObjects
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> partitionValues;
    private List<TableObject> objects;

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public void setPartitionValues(Collection<String> partitionValues) {
        if (partitionValues == null) {
            this.partitionValues = null;
            return;
        }
        this.partitionValues = new ArrayList<String>(partitionValues);
    }

    public PartitionObjects withPartitionValues(String ... partitionValues) {
        if (this.partitionValues == null) {
            this.setPartitionValues(new ArrayList<String>(partitionValues.length));
        }
        for (String ele : partitionValues) {
            this.partitionValues.add(ele);
        }
        return this;
    }

    public PartitionObjects withPartitionValues(Collection<String> partitionValues) {
        this.setPartitionValues(partitionValues);
        return this;
    }

    public List<TableObject> getObjects() {
        return this.objects;
    }

    public void setObjects(Collection<TableObject> objects) {
        if (objects == null) {
            this.objects = null;
            return;
        }
        this.objects = new ArrayList<TableObject>(objects);
    }

    public PartitionObjects withObjects(TableObject ... objects) {
        if (this.objects == null) {
            this.setObjects(new ArrayList<TableObject>(objects.length));
        }
        for (TableObject ele : objects) {
            this.objects.add(ele);
        }
        return this;
    }

    public PartitionObjects withObjects(Collection<TableObject> objects) {
        this.setObjects(objects);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPartitionValues() != null) {
            sb.append("PartitionValues: ").append(this.getPartitionValues()).append(",");
        }
        if (this.getObjects() != null) {
            sb.append("Objects: ").append(this.getObjects());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionObjects)) {
            return false;
        }
        PartitionObjects other = (PartitionObjects)obj;
        if (other.getPartitionValues() == null ^ this.getPartitionValues() == null) {
            return false;
        }
        if (other.getPartitionValues() != null && !other.getPartitionValues().equals(this.getPartitionValues())) {
            return false;
        }
        if (other.getObjects() == null ^ this.getObjects() == null) {
            return false;
        }
        return other.getObjects() == null || other.getObjects().equals(this.getObjects());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPartitionValues() == null ? 0 : this.getPartitionValues().hashCode());
        hashCode = 31 * hashCode + (this.getObjects() == null ? 0 : this.getObjects().hashCode());
        return hashCode;
    }

    public PartitionObjects clone() {
        try {
            return (PartitionObjects)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionObjectsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

