/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lexmodelsv2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.lexmodelsv2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * BedrockKnowledgeStoreConfigurationMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class BedrockKnowledgeStoreConfigurationMarshaller {

    private static final MarshallingInfo<String> BEDROCKKNOWLEDGEBASEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bedrockKnowledgeBaseArn").build();
    private static final MarshallingInfo<Boolean> EXACTRESPONSE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exactResponse").build();
    private static final MarshallingInfo<StructuredPojo> EXACTRESPONSEFIELDS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exactResponseFields").build();

    private static final BedrockKnowledgeStoreConfigurationMarshaller instance = new BedrockKnowledgeStoreConfigurationMarshaller();

    public static BedrockKnowledgeStoreConfigurationMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration, ProtocolMarshaller protocolMarshaller) {

        if (bedrockKnowledgeStoreConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(bedrockKnowledgeStoreConfiguration.getBedrockKnowledgeBaseArn(), BEDROCKKNOWLEDGEBASEARN_BINDING);
            protocolMarshaller.marshall(bedrockKnowledgeStoreConfiguration.getExactResponse(), EXACTRESPONSE_BINDING);
            protocolMarshaller.marshall(bedrockKnowledgeStoreConfiguration.getExactResponseFields(), EXACTRESPONSEFIELDS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
