/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.LegGeometry;
import com.amazonaws.services.location.model.Step;
import com.amazonaws.services.location.model.transform.LegMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Leg
implements Serializable,
Cloneable,
StructuredPojo {
    private Double distance;
    private Double durationSeconds;
    private List<Double> endPosition;
    private LegGeometry geometry;
    private List<Double> startPosition;
    private List<Step> steps;

    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public Double getDistance() {
        return this.distance;
    }

    public Leg withDistance(Double distance) {
        this.setDistance(distance);
        return this;
    }

    public void setDurationSeconds(Double durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public Double getDurationSeconds() {
        return this.durationSeconds;
    }

    public Leg withDurationSeconds(Double durationSeconds) {
        this.setDurationSeconds(durationSeconds);
        return this;
    }

    public List<Double> getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(Collection<Double> endPosition) {
        if (endPosition == null) {
            this.endPosition = null;
            return;
        }
        this.endPosition = new ArrayList<Double>(endPosition);
    }

    public Leg withEndPosition(Double ... endPosition) {
        if (this.endPosition == null) {
            this.setEndPosition(new ArrayList<Double>(endPosition.length));
        }
        for (Double ele : endPosition) {
            this.endPosition.add(ele);
        }
        return this;
    }

    public Leg withEndPosition(Collection<Double> endPosition) {
        this.setEndPosition(endPosition);
        return this;
    }

    public void setGeometry(LegGeometry geometry) {
        this.geometry = geometry;
    }

    public LegGeometry getGeometry() {
        return this.geometry;
    }

    public Leg withGeometry(LegGeometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public List<Double> getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(Collection<Double> startPosition) {
        if (startPosition == null) {
            this.startPosition = null;
            return;
        }
        this.startPosition = new ArrayList<Double>(startPosition);
    }

    public Leg withStartPosition(Double ... startPosition) {
        if (this.startPosition == null) {
            this.setStartPosition(new ArrayList<Double>(startPosition.length));
        }
        for (Double ele : startPosition) {
            this.startPosition.add(ele);
        }
        return this;
    }

    public Leg withStartPosition(Collection<Double> startPosition) {
        this.setStartPosition(startPosition);
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<Step> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<Step>(steps);
    }

    public Leg withSteps(Step ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<Step>(steps.length));
        }
        for (Step ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public Leg withSteps(Collection<Step> steps) {
        this.setSteps(steps);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDistance() != null) {
            sb.append("Distance: ").append(this.getDistance()).append(",");
        }
        if (this.getDurationSeconds() != null) {
            sb.append("DurationSeconds: ").append(this.getDurationSeconds()).append(",");
        }
        if (this.getEndPosition() != null) {
            sb.append("EndPosition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry()).append(",");
        }
        if (this.getStartPosition() != null) {
            sb.append("StartPosition: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Leg)) {
            return false;
        }
        Leg other = (Leg)obj;
        if (other.getDistance() == null ^ this.getDistance() == null) {
            return false;
        }
        if (other.getDistance() != null && !other.getDistance().equals(this.getDistance())) {
            return false;
        }
        if (other.getDurationSeconds() == null ^ this.getDurationSeconds() == null) {
            return false;
        }
        if (other.getDurationSeconds() != null && !other.getDurationSeconds().equals(this.getDurationSeconds())) {
            return false;
        }
        if (other.getEndPosition() == null ^ this.getEndPosition() == null) {
            return false;
        }
        if (other.getEndPosition() != null && !other.getEndPosition().equals(this.getEndPosition())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        if (other.getGeometry() != null && !other.getGeometry().equals(this.getGeometry())) {
            return false;
        }
        if (other.getStartPosition() == null ^ this.getStartPosition() == null) {
            return false;
        }
        if (other.getStartPosition() != null && !other.getStartPosition().equals(this.getStartPosition())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        return other.getSteps() == null || other.getSteps().equals(this.getSteps());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDistance() == null ? 0 : this.getDistance().hashCode());
        hashCode = 31 * hashCode + (this.getDurationSeconds() == null ? 0 : this.getDurationSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getEndPosition() == null ? 0 : this.getEndPosition().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getStartPosition() == null ? 0 : this.getStartPosition().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        return hashCode;
    }

    public Leg clone() {
        try {
            return (Leg)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LegMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

