/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.mainframemodernization.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DatasetDetailOrgAttributesMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DatasetDetailOrgAttributesMarshaller {

    private static final MarshallingInfo<StructuredPojo> GDG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gdg").build();
    private static final MarshallingInfo<StructuredPojo> PO_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("po").build();
    private static final MarshallingInfo<StructuredPojo> PS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ps").build();
    private static final MarshallingInfo<StructuredPojo> VSAM_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vsam").build();

    private static final DatasetDetailOrgAttributesMarshaller instance = new DatasetDetailOrgAttributesMarshaller();

    public static DatasetDetailOrgAttributesMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DatasetDetailOrgAttributes datasetDetailOrgAttributes, ProtocolMarshaller protocolMarshaller) {

        if (datasetDetailOrgAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(datasetDetailOrgAttributes.getGdg(), GDG_BINDING);
            protocolMarshaller.marshall(datasetDetailOrgAttributes.getPo(), PO_BINDING);
            protocolMarshaller.marshall(datasetDetailOrgAttributes.getPs(), PS_BINDING);
            protocolMarshaller.marshall(datasetDetailOrgAttributes.getVsam(), VSAM_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
