/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.marketplacecatalog.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Object that contains summarized information about an AMI product.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/AmiProductSummary"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AmiProductSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     */
    private String productTitle;
    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     */
    private String visibility;

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     * 
     * @param productTitle
     *        The title of the AMI product.
     */

    public void setProductTitle(String productTitle) {
        this.productTitle = productTitle;
    }

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     * 
     * @return The title of the AMI product.
     */

    public String getProductTitle() {
        return this.productTitle;
    }

    /**
     * <p>
     * The title of the AMI product.
     * </p>
     * 
     * @param productTitle
     *        The title of the AMI product.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AmiProductSummary withProductTitle(String productTitle) {
        setProductTitle(productTitle);
        return this;
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * 
     * @param visibility
     *        The lifecycle of the AMI product.
     * @see AmiProductVisibilityString
     */

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * 
     * @return The lifecycle of the AMI product.
     * @see AmiProductVisibilityString
     */

    public String getVisibility() {
        return this.visibility;
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * 
     * @param visibility
     *        The lifecycle of the AMI product.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AmiProductVisibilityString
     */

    public AmiProductSummary withVisibility(String visibility) {
        setVisibility(visibility);
        return this;
    }

    /**
     * <p>
     * The lifecycle of the AMI product.
     * </p>
     * 
     * @param visibility
     *        The lifecycle of the AMI product.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see AmiProductVisibilityString
     */

    public AmiProductSummary withVisibility(AmiProductVisibilityString visibility) {
        this.visibility = visibility.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProductTitle() != null)
            sb.append("ProductTitle: ").append(getProductTitle()).append(",");
        if (getVisibility() != null)
            sb.append("Visibility: ").append(getVisibility());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AmiProductSummary == false)
            return false;
        AmiProductSummary other = (AmiProductSummary) obj;
        if (other.getProductTitle() == null ^ this.getProductTitle() == null)
            return false;
        if (other.getProductTitle() != null && other.getProductTitle().equals(this.getProductTitle()) == false)
            return false;
        if (other.getVisibility() == null ^ this.getVisibility() == null)
            return false;
        if (other.getVisibility() != null && other.getVisibility().equals(this.getVisibility()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProductTitle() == null) ? 0 : getProductTitle().hashCode());
        hashCode = prime * hashCode + ((getVisibility() == null) ? 0 : getVisibility().hashCode());
        return hashCode;
    }

    @Override
    public AmiProductSummary clone() {
        try {
            return (AmiProductSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.marketplacecatalog.model.transform.AmiProductSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
