/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediaconnect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/MessageDetail" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MessageDetail implements Serializable, Cloneable, StructuredPojo {

    /** The error code. */
    private String code;
    /**
     * The specific error message that MediaConnect returns to help you understand the reason that the request did not
     * succeed.
     */
    private String message;
    /** The name of the resource. */
    private String resourceName;

    /**
     * The error code.
     * 
     * @param code
     *        The error code.
     */

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * The error code.
     * 
     * @return The error code.
     */

    public String getCode() {
        return this.code;
    }

    /**
     * The error code.
     * 
     * @param code
     *        The error code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MessageDetail withCode(String code) {
        setCode(code);
        return this;
    }

    /**
     * The specific error message that MediaConnect returns to help you understand the reason that the request did not
     * succeed.
     * 
     * @param message
     *        The specific error message that MediaConnect returns to help you understand the reason that the request
     *        did not succeed.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * The specific error message that MediaConnect returns to help you understand the reason that the request did not
     * succeed.
     * 
     * @return The specific error message that MediaConnect returns to help you understand the reason that the request
     *         did not succeed.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * The specific error message that MediaConnect returns to help you understand the reason that the request did not
     * succeed.
     * 
     * @param message
     *        The specific error message that MediaConnect returns to help you understand the reason that the request
     *        did not succeed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MessageDetail withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * The name of the resource.
     * 
     * @param resourceName
     *        The name of the resource.
     */

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * The name of the resource.
     * 
     * @return The name of the resource.
     */

    public String getResourceName() {
        return this.resourceName;
    }

    /**
     * The name of the resource.
     * 
     * @param resourceName
     *        The name of the resource.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MessageDetail withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getCode() != null)
            sb.append("Code: ").append(getCode()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getResourceName() != null)
            sb.append("ResourceName: ").append(getResourceName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MessageDetail == false)
            return false;
        MessageDetail other = (MessageDetail) obj;
        if (other.getCode() == null ^ this.getCode() == null)
            return false;
        if (other.getCode() != null && other.getCode().equals(this.getCode()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getResourceName() == null ^ this.getResourceName() == null)
            return false;
        if (other.getResourceName() != null && other.getResourceName().equals(this.getResourceName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getCode() == null) ? 0 : getCode().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getResourceName() == null) ? 0 : getResourceName().hashCode());
        return hashCode;
    }

    @Override
    public MessageDetail clone() {
        try {
            return (MessageDetail) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mediaconnect.model.transform.MessageDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
