/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.Mp3Settings;

@SdkInternalApi
public class Mp3SettingsMarshaller {
    private static final MarshallingInfo<Integer> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").build();
    private static final MarshallingInfo<Integer> CHANNELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channels").build();
    private static final MarshallingInfo<String> RATECONTROLMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rateControlMode").build();
    private static final MarshallingInfo<Integer> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sampleRate").build();
    private static final MarshallingInfo<Integer> VBRQUALITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vbrQuality").build();
    private static final Mp3SettingsMarshaller instance = new Mp3SettingsMarshaller();

    public static Mp3SettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(Mp3Settings mp3Settings, ProtocolMarshaller protocolMarshaller) {
        if (mp3Settings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mp3Settings.getBitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)mp3Settings.getChannels(), CHANNELS_BINDING);
            protocolMarshaller.marshall((Object)mp3Settings.getRateControlMode(), RATECONTROLMODE_BINDING);
            protocolMarshaller.marshall((Object)mp3Settings.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall((Object)mp3Settings.getVbrQuality(), VBRQUALITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

