/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.medialive.model.ChannelClass;
import com.amazonaws.services.medialive.model.OutputDestination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateChannelClassRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelClass;
    private String channelId;
    private List<OutputDestination> destinations;

    public void setChannelClass(String channelClass) {
        this.channelClass = channelClass;
    }

    public String getChannelClass() {
        return this.channelClass;
    }

    public UpdateChannelClassRequest withChannelClass(String channelClass) {
        this.setChannelClass(channelClass);
        return this;
    }

    public UpdateChannelClassRequest withChannelClass(ChannelClass channelClass) {
        this.channelClass = channelClass.toString();
        return this;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public UpdateChannelClassRequest withChannelId(String channelId) {
        this.setChannelId(channelId);
        return this;
    }

    public List<OutputDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<OutputDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<OutputDestination>(destinations);
    }

    public UpdateChannelClassRequest withDestinations(OutputDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<OutputDestination>(destinations.length));
        }
        for (OutputDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public UpdateChannelClassRequest withDestinations(Collection<OutputDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelClass() != null) {
            sb.append("ChannelClass: ").append(this.getChannelClass()).append(",");
        }
        if (this.getChannelId() != null) {
            sb.append("ChannelId: ").append(this.getChannelId()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelClassRequest)) {
            return false;
        }
        UpdateChannelClassRequest other = (UpdateChannelClassRequest)obj;
        if (other.getChannelClass() == null ^ this.getChannelClass() == null) {
            return false;
        }
        if (other.getChannelClass() != null && !other.getChannelClass().equals(this.getChannelClass())) {
            return false;
        }
        if (other.getChannelId() == null ^ this.getChannelId() == null) {
            return false;
        }
        if (other.getChannelId() != null && !other.getChannelId().equals(this.getChannelId())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelClass() == null ? 0 : this.getChannelClass().hashCode());
        hashCode = 31 * hashCode + (this.getChannelId() == null ? 0 : this.getChannelId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public UpdateChannelClassRequest clone() {
        return (UpdateChannelClassRequest)super.clone();
    }
}

