/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.medialive.model.RemixSettings;
import java.util.List;

@SdkInternalApi
public class RemixSettingsMarshaller {
    private static final MarshallingInfo<List> CHANNELMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelMappings").build();
    private static final MarshallingInfo<Integer> CHANNELSIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsIn").build();
    private static final MarshallingInfo<Integer> CHANNELSOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsOut").build();
    private static final RemixSettingsMarshaller instance = new RemixSettingsMarshaller();

    public static RemixSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(RemixSettings remixSettings, ProtocolMarshaller protocolMarshaller) {
        if (remixSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(remixSettings.getChannelMappings(), CHANNELMAPPINGS_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.getChannelsIn(), CHANNELSIN_BINDING);
            protocolMarshaller.marshall((Object)remixSettings.getChannelsOut(), CHANNELSOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

