/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagevod.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediapackagevod.model.HlsPackage;
import java.util.List;

@SdkInternalApi
public class HlsPackageMarshaller {
    private static final MarshallingInfo<StructuredPojo> ENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryption").build();
    private static final MarshallingInfo<List> HLSMANIFESTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsManifests").build();
    private static final MarshallingInfo<Boolean> INCLUDEDVBSUBTITLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("includeDvbSubtitles").build();
    private static final MarshallingInfo<Integer> SEGMENTDURATIONSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("segmentDurationSeconds").build();
    private static final MarshallingInfo<Boolean> USEAUDIORENDITIONGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("useAudioRenditionGroup").build();
    private static final HlsPackageMarshaller instance = new HlsPackageMarshaller();

    public static HlsPackageMarshaller getInstance() {
        return instance;
    }

    public void marshall(HlsPackage hlsPackage, ProtocolMarshaller protocolMarshaller) {
        if (hlsPackage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hlsPackage.getEncryption(), ENCRYPTION_BINDING);
            protocolMarshaller.marshall(hlsPackage.getHlsManifests(), HLSMANIFESTS_BINDING);
            protocolMarshaller.marshall((Object)hlsPackage.getIncludeDvbSubtitles(), INCLUDEDVBSUBTITLES_BINDING);
            protocolMarshaller.marshall((Object)hlsPackage.getSegmentDurationSeconds(), SEGMENTDURATIONSECONDS_BINDING);
            protocolMarshaller.marshall((Object)hlsPackage.getUseAudioRenditionGroup(), USEAUDIORENDITIONGROUP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

