/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.neptune.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDBEngineVersionsRequestMarshaller
implements Marshaller<Request<DescribeDBEngineVersionsRequest>, DescribeDBEngineVersionsRequest> {
    public Request<DescribeDBEngineVersionsRequest> marshall(DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) {
        if (describeDBEngineVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBEngineVersionsRequest, "AmazonNeptune");
        request.addParameter("Action", "DescribeDBEngineVersions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBEngineVersionsRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeDBEngineVersionsRequest.getEngine()));
        }
        if (describeDBEngineVersionsRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeDBEngineVersionsRequest.getEngineVersion()));
        }
        if (describeDBEngineVersionsRequest.getDBParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringUtils.fromString((String)describeDBEngineVersionsRequest.getDBParameterGroupFamily()));
        }
        if (describeDBEngineVersionsRequest.getFilters() != null) {
            List<Filter> filtersList = describeDBEngineVersionsRequest.getFilters();
            if (filtersList.isEmpty()) {
                request.addParameter("Filters", "");
            } else {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue != null) {
                        if (filtersListValue.getName() != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                        }
                        if (filtersListValue.getValues() != null) {
                            List<String> valuesList = filtersListValue.getValues();
                            if (valuesList.isEmpty()) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                            } else {
                                int valuesListIndex = 1;
                                for (String valuesListValue : valuesList) {
                                    if (valuesListValue != null) {
                                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                    }
                                    ++valuesListIndex;
                                }
                            }
                        }
                    }
                    ++filtersListIndex;
                }
            }
        }
        if (describeDBEngineVersionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBEngineVersionsRequest.getMaxRecords()));
        }
        if (describeDBEngineVersionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBEngineVersionsRequest.getMarker()));
        }
        if (describeDBEngineVersionsRequest.getDefaultOnly() != null) {
            request.addParameter("DefaultOnly", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.getDefaultOnly()));
        }
        if (describeDBEngineVersionsRequest.getListSupportedCharacterSets() != null) {
            request.addParameter("ListSupportedCharacterSets", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.getListSupportedCharacterSets()));
        }
        if (describeDBEngineVersionsRequest.getListSupportedTimezones() != null) {
            request.addParameter("ListSupportedTimezones", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.getListSupportedTimezones()));
        }
        return request;
    }
}

