/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.networkmanager.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCoreNetworkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String globalNetworkId;
    private String description;
    private List<Tag> tags;
    private String policyDocument;
    private String clientToken;

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public CreateCoreNetworkRequest withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateCoreNetworkRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateCoreNetworkRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateCoreNetworkRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public CreateCoreNetworkRequest withPolicyDocument(String policyDocument) {
        this.setPolicyDocument(policyDocument);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateCoreNetworkRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.getPolicyDocument()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCoreNetworkRequest)) {
            return false;
        }
        CreateCoreNetworkRequest other = (CreateCoreNetworkRequest)obj;
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateCoreNetworkRequest clone() {
        return (CreateCoreNetworkRequest)super.clone();
    }
}

