/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.Bandwidth;
import com.amazonaws.services.networkmanager.model.LinkState;
import com.amazonaws.services.networkmanager.model.Tag;
import com.amazonaws.services.networkmanager.model.transform.LinkMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Link
implements Serializable,
Cloneable,
StructuredPojo {
    private String linkId;
    private String linkArn;
    private String globalNetworkId;
    private String siteId;
    private String description;
    private String type;
    private Bandwidth bandwidth;
    private String provider;
    private Date createdAt;
    private String state;
    private List<Tag> tags;

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public Link withLinkId(String linkId) {
        this.setLinkId(linkId);
        return this;
    }

    public void setLinkArn(String linkArn) {
        this.linkArn = linkArn;
    }

    public String getLinkArn() {
        return this.linkArn;
    }

    public Link withLinkArn(String linkArn) {
        this.setLinkArn(linkArn);
        return this;
    }

    public void setGlobalNetworkId(String globalNetworkId) {
        this.globalNetworkId = globalNetworkId;
    }

    public String getGlobalNetworkId() {
        return this.globalNetworkId;
    }

    public Link withGlobalNetworkId(String globalNetworkId) {
        this.setGlobalNetworkId(globalNetworkId);
        return this;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public Link withSiteId(String siteId) {
        this.setSiteId(siteId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Link withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Link withType(String type) {
        this.setType(type);
        return this;
    }

    public void setBandwidth(Bandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public Bandwidth getBandwidth() {
        return this.bandwidth;
    }

    public Link withBandwidth(Bandwidth bandwidth) {
        this.setBandwidth(bandwidth);
        return this;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getProvider() {
        return this.provider;
    }

    public Link withProvider(String provider) {
        this.setProvider(provider);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Link withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Link withState(String state) {
        this.setState(state);
        return this;
    }

    public Link withState(LinkState state) {
        this.state = state.toString();
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Link withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Link withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLinkId() != null) {
            sb.append("LinkId: ").append(this.getLinkId()).append(",");
        }
        if (this.getLinkArn() != null) {
            sb.append("LinkArn: ").append(this.getLinkArn()).append(",");
        }
        if (this.getGlobalNetworkId() != null) {
            sb.append("GlobalNetworkId: ").append(this.getGlobalNetworkId()).append(",");
        }
        if (this.getSiteId() != null) {
            sb.append("SiteId: ").append(this.getSiteId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getBandwidth() != null) {
            sb.append("Bandwidth: ").append(this.getBandwidth()).append(",");
        }
        if (this.getProvider() != null) {
            sb.append("Provider: ").append(this.getProvider()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link other = (Link)obj;
        if (other.getLinkId() == null ^ this.getLinkId() == null) {
            return false;
        }
        if (other.getLinkId() != null && !other.getLinkId().equals(this.getLinkId())) {
            return false;
        }
        if (other.getLinkArn() == null ^ this.getLinkArn() == null) {
            return false;
        }
        if (other.getLinkArn() != null && !other.getLinkArn().equals(this.getLinkArn())) {
            return false;
        }
        if (other.getGlobalNetworkId() == null ^ this.getGlobalNetworkId() == null) {
            return false;
        }
        if (other.getGlobalNetworkId() != null && !other.getGlobalNetworkId().equals(this.getGlobalNetworkId())) {
            return false;
        }
        if (other.getSiteId() == null ^ this.getSiteId() == null) {
            return false;
        }
        if (other.getSiteId() != null && !other.getSiteId().equals(this.getSiteId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getBandwidth() == null ^ this.getBandwidth() == null) {
            return false;
        }
        if (other.getBandwidth() != null && !other.getBandwidth().equals(this.getBandwidth())) {
            return false;
        }
        if (other.getProvider() == null ^ this.getProvider() == null) {
            return false;
        }
        if (other.getProvider() != null && !other.getProvider().equals(this.getProvider())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLinkId() == null ? 0 : this.getLinkId().hashCode());
        hashCode = 31 * hashCode + (this.getLinkArn() == null ? 0 : this.getLinkArn().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalNetworkId() == null ? 0 : this.getGlobalNetworkId().hashCode());
        hashCode = 31 * hashCode + (this.getSiteId() == null ? 0 : this.getSiteId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getBandwidth() == null ? 0 : this.getBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.getProvider() == null ? 0 : this.getProvider().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Link clone() {
        try {
            return (Link)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LinkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

