/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.PathComponent;
import com.amazonaws.services.networkmanager.model.RouteAnalysisCompletion;
import com.amazonaws.services.networkmanager.model.transform.RouteAnalysisPathMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RouteAnalysisPath
implements Serializable,
Cloneable,
StructuredPojo {
    private RouteAnalysisCompletion completionStatus;
    private List<PathComponent> path;

    public void setCompletionStatus(RouteAnalysisCompletion completionStatus) {
        this.completionStatus = completionStatus;
    }

    public RouteAnalysisCompletion getCompletionStatus() {
        return this.completionStatus;
    }

    public RouteAnalysisPath withCompletionStatus(RouteAnalysisCompletion completionStatus) {
        this.setCompletionStatus(completionStatus);
        return this;
    }

    public List<PathComponent> getPath() {
        return this.path;
    }

    public void setPath(Collection<PathComponent> path) {
        if (path == null) {
            this.path = null;
            return;
        }
        this.path = new ArrayList<PathComponent>(path);
    }

    public RouteAnalysisPath withPath(PathComponent ... path) {
        if (this.path == null) {
            this.setPath(new ArrayList<PathComponent>(path.length));
        }
        for (PathComponent ele : path) {
            this.path.add(ele);
        }
        return this;
    }

    public RouteAnalysisPath withPath(Collection<PathComponent> path) {
        this.setPath(path);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCompletionStatus() != null) {
            sb.append("CompletionStatus: ").append(this.getCompletionStatus()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAnalysisPath)) {
            return false;
        }
        RouteAnalysisPath other = (RouteAnalysisPath)obj;
        if (other.getCompletionStatus() == null ^ this.getCompletionStatus() == null) {
            return false;
        }
        if (other.getCompletionStatus() != null && !other.getCompletionStatus().equals(this.getCompletionStatus())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        return other.getPath() == null || other.getPath().equals(this.getPath());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCompletionStatus() == null ? 0 : this.getCompletionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        return hashCode;
    }

    public RouteAnalysisPath clone() {
        try {
            return (RouteAnalysisPath)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RouteAnalysisPathMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

