/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.organizations.model.Root;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRootsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Root> roots;
    private String nextToken;

    public List<Root> getRoots() {
        return this.roots;
    }

    public void setRoots(Collection<Root> roots) {
        if (roots == null) {
            this.roots = null;
            return;
        }
        this.roots = new ArrayList<Root>(roots);
    }

    public ListRootsResult withRoots(Root ... roots) {
        if (this.roots == null) {
            this.setRoots(new ArrayList<Root>(roots.length));
        }
        for (Root ele : roots) {
            this.roots.add(ele);
        }
        return this;
    }

    public ListRootsResult withRoots(Collection<Root> roots) {
        this.setRoots(roots);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRootsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoots() != null) {
            sb.append("Roots: ").append(this.getRoots()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRootsResult)) {
            return false;
        }
        ListRootsResult other = (ListRootsResult)obj;
        if (other.getRoots() == null ^ this.getRoots() == null) {
            return false;
        }
        if (other.getRoots() != null && !other.getRoots().equals(this.getRoots())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoots() == null ? 0 : this.getRoots().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRootsResult clone() {
        try {
            return (ListRootsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

