/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pcaconnectorad.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pca-connector-ad-2018-05-10/GetServicePrincipalName"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetServicePrincipalNameResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     */
    private ServicePrincipalName servicePrincipalName;

    /**
     * <p>
     * The service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     * 
     * @param servicePrincipalName
     *        The service principal name that the connector uses to authenticate with Active Directory.
     */

    public void setServicePrincipalName(ServicePrincipalName servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
    }

    /**
     * <p>
     * The service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     * 
     * @return The service principal name that the connector uses to authenticate with Active Directory.
     */

    public ServicePrincipalName getServicePrincipalName() {
        return this.servicePrincipalName;
    }

    /**
     * <p>
     * The service principal name that the connector uses to authenticate with Active Directory.
     * </p>
     * 
     * @param servicePrincipalName
     *        The service principal name that the connector uses to authenticate with Active Directory.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetServicePrincipalNameResult withServicePrincipalName(ServicePrincipalName servicePrincipalName) {
        setServicePrincipalName(servicePrincipalName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getServicePrincipalName() != null)
            sb.append("ServicePrincipalName: ").append(getServicePrincipalName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetServicePrincipalNameResult == false)
            return false;
        GetServicePrincipalNameResult other = (GetServicePrincipalNameResult) obj;
        if (other.getServicePrincipalName() == null ^ this.getServicePrincipalName() == null)
            return false;
        if (other.getServicePrincipalName() != null && other.getServicePrincipalName().equals(this.getServicePrincipalName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getServicePrincipalName() == null) ? 0 : getServicePrincipalName().hashCode());
        return hashCode;
    }

    @Override
    public GetServicePrincipalNameResult clone() {
        try {
            return (GetServicePrincipalNameResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
