/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.personalize.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/CreateBatchSegmentJob" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateBatchSegmentJobRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the batch segment job to create.
     * </p>
     */
    private String jobName;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch
     * segments.
     * </p>
     */
    private String solutionVersionArn;
    /**
     * <p>
     * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     */
    private String filterArn;
    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     */
    private Integer numResults;
    /**
     * <p>
     * The Amazon S3 path for the input data used to generate the batch segment job.
     * </p>
     */
    private BatchSegmentJobInput jobInput;
    /**
     * <p>
     * The Amazon S3 path for the bucket where the job's output will be stored.
     * </p>
     */
    private BatchSegmentJobOutput jobOutput;
    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     */
    private String roleArn;
    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     */
    private java.util.List<Tag> tags;

    /**
     * <p>
     * The name of the batch segment job to create.
     * </p>
     * 
     * @param jobName
     *        The name of the batch segment job to create.
     */

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * <p>
     * The name of the batch segment job to create.
     * </p>
     * 
     * @return The name of the batch segment job to create.
     */

    public String getJobName() {
        return this.jobName;
    }

    /**
     * <p>
     * The name of the batch segment job to create.
     * </p>
     * 
     * @param jobName
     *        The name of the batch segment job to create.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withJobName(String jobName) {
        setJobName(jobName);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch
     * segments.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
     *        batch segments.
     */

    public void setSolutionVersionArn(String solutionVersionArn) {
        this.solutionVersionArn = solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch
     * segments.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
     *         batch segments.
     */

    public String getSolutionVersionArn() {
        return this.solutionVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch
     * segments.
     * </p>
     * 
     * @param solutionVersionArn
     *        The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate
     *        batch segments.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withSolutionVersionArn(String solutionVersionArn) {
        setSolutionVersionArn(solutionVersionArn);
        return this;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     * 
     * @param filterArn
     *        The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
     *        recommendations</a>.
     */

    public void setFilterArn(String filterArn) {
        this.filterArn = filterArn;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     * 
     * @return The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     *         href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
     *         recommendations</a>.
     */

    public String getFilterArn() {
        return this.filterArn;
    }

    /**
     * <p>
     * The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     * href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.
     * </p>
     * 
     * @param filterArn
     *        The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a
     *        href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch
     *        recommendations</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withFilterArn(String filterArn) {
        setFilterArn(filterArn);
        return this;
    }

    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     * 
     * @param numResults
     *        The number of predicted users generated by the batch segment job for each line of input data. The maximum
     *        number of users per segment is 5 million.
     */

    public void setNumResults(Integer numResults) {
        this.numResults = numResults;
    }

    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     * 
     * @return The number of predicted users generated by the batch segment job for each line of input data. The maximum
     *         number of users per segment is 5 million.
     */

    public Integer getNumResults() {
        return this.numResults;
    }

    /**
     * <p>
     * The number of predicted users generated by the batch segment job for each line of input data. The maximum number
     * of users per segment is 5 million.
     * </p>
     * 
     * @param numResults
     *        The number of predicted users generated by the batch segment job for each line of input data. The maximum
     *        number of users per segment is 5 million.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withNumResults(Integer numResults) {
        setNumResults(numResults);
        return this;
    }

    /**
     * <p>
     * The Amazon S3 path for the input data used to generate the batch segment job.
     * </p>
     * 
     * @param jobInput
     *        The Amazon S3 path for the input data used to generate the batch segment job.
     */

    public void setJobInput(BatchSegmentJobInput jobInput) {
        this.jobInput = jobInput;
    }

    /**
     * <p>
     * The Amazon S3 path for the input data used to generate the batch segment job.
     * </p>
     * 
     * @return The Amazon S3 path for the input data used to generate the batch segment job.
     */

    public BatchSegmentJobInput getJobInput() {
        return this.jobInput;
    }

    /**
     * <p>
     * The Amazon S3 path for the input data used to generate the batch segment job.
     * </p>
     * 
     * @param jobInput
     *        The Amazon S3 path for the input data used to generate the batch segment job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withJobInput(BatchSegmentJobInput jobInput) {
        setJobInput(jobInput);
        return this;
    }

    /**
     * <p>
     * The Amazon S3 path for the bucket where the job's output will be stored.
     * </p>
     * 
     * @param jobOutput
     *        The Amazon S3 path for the bucket where the job's output will be stored.
     */

    public void setJobOutput(BatchSegmentJobOutput jobOutput) {
        this.jobOutput = jobOutput;
    }

    /**
     * <p>
     * The Amazon S3 path for the bucket where the job's output will be stored.
     * </p>
     * 
     * @return The Amazon S3 path for the bucket where the job's output will be stored.
     */

    public BatchSegmentJobOutput getJobOutput() {
        return this.jobOutput;
    }

    /**
     * <p>
     * The Amazon S3 path for the bucket where the job's output will be stored.
     * </p>
     * 
     * @param jobOutput
     *        The Amazon S3 path for the bucket where the job's output will be stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withJobOutput(BatchSegmentJobOutput jobOutput) {
        setJobOutput(jobOutput);
        return this;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     * 
     * @param roleArn
     *        The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *        input and output Amazon S3 buckets respectively.
     */

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     * 
     * @return The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *         input and output Amazon S3 buckets respectively.
     */

    public String getRoleArn() {
        return this.roleArn;
    }

    /**
     * <p>
     * The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input
     * and output Amazon S3 buckets respectively.
     * </p>
     * 
     * @param roleArn
     *        The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your
     *        input and output Amazon S3 buckets respectively.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withRoleArn(String roleArn) {
        setRoleArn(roleArn);
        return this;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *         apply to the batch segment job.
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the batch segment job.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the batch segment job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to
     * the batch segment job.
     * </p>
     * 
     * @param tags
     *        A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to
     *        apply to the batch segment job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateBatchSegmentJobRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobName() != null)
            sb.append("JobName: ").append(getJobName()).append(",");
        if (getSolutionVersionArn() != null)
            sb.append("SolutionVersionArn: ").append(getSolutionVersionArn()).append(",");
        if (getFilterArn() != null)
            sb.append("FilterArn: ").append(getFilterArn()).append(",");
        if (getNumResults() != null)
            sb.append("NumResults: ").append(getNumResults()).append(",");
        if (getJobInput() != null)
            sb.append("JobInput: ").append(getJobInput()).append(",");
        if (getJobOutput() != null)
            sb.append("JobOutput: ").append(getJobOutput()).append(",");
        if (getRoleArn() != null)
            sb.append("RoleArn: ").append(getRoleArn()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateBatchSegmentJobRequest == false)
            return false;
        CreateBatchSegmentJobRequest other = (CreateBatchSegmentJobRequest) obj;
        if (other.getJobName() == null ^ this.getJobName() == null)
            return false;
        if (other.getJobName() != null && other.getJobName().equals(this.getJobName()) == false)
            return false;
        if (other.getSolutionVersionArn() == null ^ this.getSolutionVersionArn() == null)
            return false;
        if (other.getSolutionVersionArn() != null && other.getSolutionVersionArn().equals(this.getSolutionVersionArn()) == false)
            return false;
        if (other.getFilterArn() == null ^ this.getFilterArn() == null)
            return false;
        if (other.getFilterArn() != null && other.getFilterArn().equals(this.getFilterArn()) == false)
            return false;
        if (other.getNumResults() == null ^ this.getNumResults() == null)
            return false;
        if (other.getNumResults() != null && other.getNumResults().equals(this.getNumResults()) == false)
            return false;
        if (other.getJobInput() == null ^ this.getJobInput() == null)
            return false;
        if (other.getJobInput() != null && other.getJobInput().equals(this.getJobInput()) == false)
            return false;
        if (other.getJobOutput() == null ^ this.getJobOutput() == null)
            return false;
        if (other.getJobOutput() != null && other.getJobOutput().equals(this.getJobOutput()) == false)
            return false;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null)
            return false;
        if (other.getRoleArn() != null && other.getRoleArn().equals(this.getRoleArn()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobName() == null) ? 0 : getJobName().hashCode());
        hashCode = prime * hashCode + ((getSolutionVersionArn() == null) ? 0 : getSolutionVersionArn().hashCode());
        hashCode = prime * hashCode + ((getFilterArn() == null) ? 0 : getFilterArn().hashCode());
        hashCode = prime * hashCode + ((getNumResults() == null) ? 0 : getNumResults().hashCode());
        hashCode = prime * hashCode + ((getJobInput() == null) ? 0 : getJobInput().hashCode());
        hashCode = prime * hashCode + ((getJobOutput() == null) ? 0 : getJobOutput().hashCode());
        hashCode = prime * hashCode + ((getRoleArn() == null) ? 0 : getRoleArn().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateBatchSegmentJobRequest clone() {
        return (CreateBatchSegmentJobRequest) super.clone();
    }

}
