/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.personalize.model.RecipeSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecipesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RecipeSummary> recipes;
    private String nextToken;

    public List<RecipeSummary> getRecipes() {
        return this.recipes;
    }

    public void setRecipes(Collection<RecipeSummary> recipes) {
        if (recipes == null) {
            this.recipes = null;
            return;
        }
        this.recipes = new ArrayList<RecipeSummary>(recipes);
    }

    public ListRecipesResult withRecipes(RecipeSummary ... recipes) {
        if (this.recipes == null) {
            this.setRecipes(new ArrayList<RecipeSummary>(recipes.length));
        }
        for (RecipeSummary ele : recipes) {
            this.recipes.add(ele);
        }
        return this;
    }

    public ListRecipesResult withRecipes(Collection<RecipeSummary> recipes) {
        this.setRecipes(recipes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecipesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecipes() != null) {
            sb.append("Recipes: ").append(this.getRecipes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecipesResult)) {
            return false;
        }
        ListRecipesResult other = (ListRecipesResult)obj;
        if (other.getRecipes() == null ^ this.getRecipes() == null) {
            return false;
        }
        if (other.getRecipes() != null && !other.getRecipes().equals(this.getRecipes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecipes() == null ? 0 : this.getRecipes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRecipesResult clone() {
        try {
            return (ListRecipesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

