/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.personalizeruntime.model.transform.PromotionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Promotion
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Integer percentPromotedItems;
    private String filterArn;
    private Map<String, String> filterValues;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Promotion withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPercentPromotedItems(Integer percentPromotedItems) {
        this.percentPromotedItems = percentPromotedItems;
    }

    public Integer getPercentPromotedItems() {
        return this.percentPromotedItems;
    }

    public Promotion withPercentPromotedItems(Integer percentPromotedItems) {
        this.setPercentPromotedItems(percentPromotedItems);
        return this;
    }

    public void setFilterArn(String filterArn) {
        this.filterArn = filterArn;
    }

    public String getFilterArn() {
        return this.filterArn;
    }

    public Promotion withFilterArn(String filterArn) {
        this.setFilterArn(filterArn);
        return this;
    }

    public Map<String, String> getFilterValues() {
        return this.filterValues;
    }

    public void setFilterValues(Map<String, String> filterValues) {
        this.filterValues = filterValues;
    }

    public Promotion withFilterValues(Map<String, String> filterValues) {
        this.setFilterValues(filterValues);
        return this;
    }

    public Promotion addFilterValuesEntry(String key, String value) {
        if (null == this.filterValues) {
            this.filterValues = new HashMap<String, String>();
        }
        if (this.filterValues.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.filterValues.put(key, value);
        return this;
    }

    public Promotion clearFilterValuesEntries() {
        this.filterValues = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPercentPromotedItems() != null) {
            sb.append("PercentPromotedItems: ").append(this.getPercentPromotedItems()).append(",");
        }
        if (this.getFilterArn() != null) {
            sb.append("FilterArn: ").append(this.getFilterArn()).append(",");
        }
        if (this.getFilterValues() != null) {
            sb.append("FilterValues: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Promotion)) {
            return false;
        }
        Promotion other = (Promotion)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPercentPromotedItems() == null ^ this.getPercentPromotedItems() == null) {
            return false;
        }
        if (other.getPercentPromotedItems() != null && !other.getPercentPromotedItems().equals(this.getPercentPromotedItems())) {
            return false;
        }
        if (other.getFilterArn() == null ^ this.getFilterArn() == null) {
            return false;
        }
        if (other.getFilterArn() != null && !other.getFilterArn().equals(this.getFilterArn())) {
            return false;
        }
        if (other.getFilterValues() == null ^ this.getFilterValues() == null) {
            return false;
        }
        return other.getFilterValues() == null || other.getFilterValues().equals(this.getFilterValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPercentPromotedItems() == null ? 0 : this.getPercentPromotedItems().hashCode());
        hashCode = 31 * hashCode + (this.getFilterArn() == null ? 0 : this.getFilterArn().hashCode());
        hashCode = 31 * hashCode + (this.getFilterValues() == null ? 0 : this.getFilterValues().hashCode());
        return hashCode;
    }

    public Promotion clone() {
        try {
            return (Promotion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PromotionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

