/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pinpoint.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetAdmChannelResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private ADMChannelResponse aDMChannelResponse;

    /**
     * @param aDMChannelResponse
     */

    public void setADMChannelResponse(ADMChannelResponse aDMChannelResponse) {
        this.aDMChannelResponse = aDMChannelResponse;
    }

    /**
     * @return
     */

    public ADMChannelResponse getADMChannelResponse() {
        return this.aDMChannelResponse;
    }

    /**
     * @param aDMChannelResponse
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetAdmChannelResult withADMChannelResponse(ADMChannelResponse aDMChannelResponse) {
        setADMChannelResponse(aDMChannelResponse);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getADMChannelResponse() != null)
            sb.append("ADMChannelResponse: ").append(getADMChannelResponse());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetAdmChannelResult == false)
            return false;
        GetAdmChannelResult other = (GetAdmChannelResult) obj;
        if (other.getADMChannelResponse() == null ^ this.getADMChannelResponse() == null)
            return false;
        if (other.getADMChannelResponse() != null && other.getADMChannelResponse().equals(this.getADMChannelResponse()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getADMChannelResponse() == null) ? 0 : getADMChannelResponse().hashCode());
        return hashCode;
    }

    @Override
    public GetAdmChannelResult clone() {
        try {
            return (GetAdmChannelResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
