/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.AttributeDimension;
import com.amazonaws.services.pinpoint.model.MetricDimension;
import com.amazonaws.services.pinpoint.model.SetDimension;
import com.amazonaws.services.pinpoint.model.transform.EventDimensionsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class EventDimensions
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, AttributeDimension> attributes;
    private SetDimension eventType;
    private Map<String, MetricDimension> metrics;

    public Map<String, AttributeDimension> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, AttributeDimension> attributes) {
        this.attributes = attributes;
    }

    public EventDimensions withAttributes(Map<String, AttributeDimension> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public EventDimensions addAttributesEntry(String key, AttributeDimension value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, AttributeDimension>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public EventDimensions clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setEventType(SetDimension eventType) {
        this.eventType = eventType;
    }

    public SetDimension getEventType() {
        return this.eventType;
    }

    public EventDimensions withEventType(SetDimension eventType) {
        this.setEventType(eventType);
        return this;
    }

    public Map<String, MetricDimension> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, MetricDimension> metrics) {
        this.metrics = metrics;
    }

    public EventDimensions withMetrics(Map<String, MetricDimension> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public EventDimensions addMetricsEntry(String key, MetricDimension value) {
        if (null == this.metrics) {
            this.metrics = new HashMap<String, MetricDimension>();
        }
        if (this.metrics.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.metrics.put(key, value);
        return this;
    }

    public EventDimensions clearMetricsEntries() {
        this.metrics = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDimensions)) {
            return false;
        }
        EventDimensions other = (EventDimensions)obj;
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        return other.getMetrics() == null || other.getMetrics().equals(this.getMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        return hashCode;
    }

    public EventDimensions clone() {
        try {
            return (EventDimensions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventDimensionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

