/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpointemail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpointemail.model.RawMessage;
import java.nio.ByteBuffer;

@SdkInternalApi
public class RawMessageMarshaller {
    private static final MarshallingInfo<ByteBuffer> DATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Data").build();
    private static final RawMessageMarshaller instance = new RawMessageMarshaller();

    public static RawMessageMarshaller getInstance() {
        return instance;
    }

    public void marshall(RawMessage rawMessage, ProtocolMarshaller protocolMarshaller) {
        if (rawMessage == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)rawMessage.getData(), DATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

