/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.polly.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.polly.model.SynthesisTask;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SynthesisTaskMarshaller {
    private static final MarshallingInfo<String> ENGINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Engine").build();
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskId").build();
    private static final MarshallingInfo<String> TASKSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskStatus").build();
    private static final MarshallingInfo<String> TASKSTATUSREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskStatusReason").build();
    private static final MarshallingInfo<String> OUTPUTURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUri").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Integer> REQUESTCHARACTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestCharacters").build();
    private static final MarshallingInfo<String> SNSTOPICARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnsTopicArn").build();
    private static final MarshallingInfo<List> LEXICONNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LexiconNames").build();
    private static final MarshallingInfo<String> OUTPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputFormat").build();
    private static final MarshallingInfo<String> SAMPLERATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleRate").build();
    private static final MarshallingInfo<List> SPEECHMARKTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpeechMarkTypes").build();
    private static final MarshallingInfo<String> TEXTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TextType").build();
    private static final MarshallingInfo<String> VOICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VoiceId").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final SynthesisTaskMarshaller instance = new SynthesisTaskMarshaller();

    public static SynthesisTaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(SynthesisTask synthesisTask, ProtocolMarshaller protocolMarshaller) {
        if (synthesisTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)synthesisTask.getEngine(), ENGINE_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getTaskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getTaskStatus(), TASKSTATUS_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getTaskStatusReason(), TASKSTATUSREASON_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getOutputUri(), OUTPUTURI_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getRequestCharacters(), REQUESTCHARACTERS_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getSnsTopicArn(), SNSTOPICARN_BINDING);
            protocolMarshaller.marshall(synthesisTask.getLexiconNames(), LEXICONNAMES_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getOutputFormat(), OUTPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getSampleRate(), SAMPLERATE_BINDING);
            protocolMarshaller.marshall(synthesisTask.getSpeechMarkTypes(), SPEECHMARKTYPES_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getTextType(), TEXTTYPE_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getVoiceId(), VOICEID_BINDING);
            protocolMarshaller.marshall((Object)synthesisTask.getLanguageCode(), LANGUAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

