/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.qconnect;

import javax.annotation.Generated;

import com.amazonaws.services.qconnect.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonQConnect}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonQConnect implements AmazonQConnect {

    protected AbstractAmazonQConnect() {
    }

    @Override
    public CreateAssistantResult createAssistant(CreateAssistantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAssistantAssociationResult createAssistantAssociation(CreateAssistantAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContentResult createContent(CreateContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContentAssociationResult createContentAssociation(CreateContentAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateKnowledgeBaseResult createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateQuickResponseResult createQuickResponse(CreateQuickResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSessionResult createSession(CreateSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssistantResult deleteAssistant(DeleteAssistantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAssistantAssociationResult deleteAssistantAssociation(DeleteAssistantAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContentResult deleteContent(DeleteContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContentAssociationResult deleteContentAssociation(DeleteContentAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImportJobResult deleteImportJob(DeleteImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteKnowledgeBaseResult deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteQuickResponseResult deleteQuickResponse(DeleteQuickResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssistantResult getAssistant(GetAssistantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAssistantAssociationResult getAssistantAssociation(GetAssistantAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContentResult getContent(GetContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContentAssociationResult getContentAssociation(GetContentAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContentSummaryResult getContentSummary(GetContentSummaryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImportJobResult getImportJob(GetImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetKnowledgeBaseResult getKnowledgeBase(GetKnowledgeBaseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetQuickResponseResult getQuickResponse(GetQuickResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GetRecommendationsResult getRecommendations(GetRecommendationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSessionResult getSession(GetSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssistantAssociationsResult listAssistantAssociations(ListAssistantAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAssistantsResult listAssistants(ListAssistantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContentAssociationsResult listContentAssociations(ListContentAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContentsResult listContents(ListContentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImportJobsResult listImportJobs(ListImportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListKnowledgeBasesResult listKnowledgeBases(ListKnowledgeBasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListQuickResponsesResult listQuickResponses(ListQuickResponsesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public NotifyRecommendationsReceivedResult notifyRecommendationsReceived(NotifyRecommendationsReceivedRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutFeedbackResult putFeedback(PutFeedbackRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public QueryAssistantResult queryAssistant(QueryAssistantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveKnowledgeBaseTemplateUriResult removeKnowledgeBaseTemplateUri(RemoveKnowledgeBaseTemplateUriRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchContentResult searchContent(SearchContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchQuickResponsesResult searchQuickResponses(SearchQuickResponsesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchSessionsResult searchSessions(SearchSessionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartContentUploadResult startContentUpload(StartContentUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartImportJobResult startImportJob(StartImportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateContentResult updateContent(UpdateContentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateKnowledgeBaseTemplateUriResult updateKnowledgeBaseTemplateUri(UpdateKnowledgeBaseTemplateUriRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateQuickResponseResult updateQuickResponse(UpdateQuickResponseRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSessionResult updateSession(UpdateSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
