/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldb.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.qldb.model.LedgerSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLedgersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<LedgerSummary> ledgers;
    private String nextToken;

    public List<LedgerSummary> getLedgers() {
        return this.ledgers;
    }

    public void setLedgers(Collection<LedgerSummary> ledgers) {
        if (ledgers == null) {
            this.ledgers = null;
            return;
        }
        this.ledgers = new ArrayList<LedgerSummary>(ledgers);
    }

    public ListLedgersResult withLedgers(LedgerSummary ... ledgers) {
        if (this.ledgers == null) {
            this.setLedgers(new ArrayList<LedgerSummary>(ledgers.length));
        }
        for (LedgerSummary ele : ledgers) {
            this.ledgers.add(ele);
        }
        return this;
    }

    public ListLedgersResult withLedgers(Collection<LedgerSummary> ledgers) {
        this.setLedgers(ledgers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLedgersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLedgers() != null) {
            sb.append("Ledgers: ").append(this.getLedgers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLedgersResult)) {
            return false;
        }
        ListLedgersResult other = (ListLedgersResult)obj;
        if (other.getLedgers() == null ^ this.getLedgers() == null) {
            return false;
        }
        if (other.getLedgers() != null && !other.getLedgers().equals(this.getLedgers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLedgers() == null ? 0 : this.getLedgers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLedgersResult clone() {
        try {
            return (ListLedgersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

