/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ram.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceShareArn;
    private List<Tag> tags;
    private String resourceArn;

    public void setResourceShareArn(String resourceShareArn) {
        this.resourceShareArn = resourceShareArn;
    }

    public String getResourceShareArn() {
        return this.resourceShareArn;
    }

    public TagResourceRequest withResourceShareArn(String resourceShareArn) {
        this.setResourceShareArn(resourceShareArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public TagResourceRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TagResourceRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public TagResourceRequest withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceShareArn() != null) {
            sb.append("ResourceShareArn: ").append(this.getResourceShareArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)obj;
        if (other.getResourceShareArn() == null ^ this.getResourceShareArn() == null) {
            return false;
        }
        if (other.getResourceShareArn() != null && !other.getResourceShareArn().equals(this.getResourceShareArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        return other.getResourceArn() == null || other.getResourceArn().equals(this.getResourceArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceShareArn() == null ? 0 : this.getResourceShareArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        return hashCode;
    }

    public TagResourceRequest clone() {
        return (TagResourceRequest)super.clone();
    }
}

