/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.route53recoveryreadiness.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateResourceSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceSetName;
    private String resourceSetType;
    private List<Resource> resources;

    public void setResourceSetName(String resourceSetName) {
        this.resourceSetName = resourceSetName;
    }

    public String getResourceSetName() {
        return this.resourceSetName;
    }

    public UpdateResourceSetRequest withResourceSetName(String resourceSetName) {
        this.setResourceSetName(resourceSetName);
        return this;
    }

    public void setResourceSetType(String resourceSetType) {
        this.resourceSetType = resourceSetType;
    }

    public String getResourceSetType() {
        return this.resourceSetType;
    }

    public UpdateResourceSetRequest withResourceSetType(String resourceSetType) {
        this.setResourceSetType(resourceSetType);
        return this;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<Resource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<Resource>(resources);
    }

    public UpdateResourceSetRequest withResources(Resource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<Resource>(resources.length));
        }
        for (Resource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public UpdateResourceSetRequest withResources(Collection<Resource> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceSetName() != null) {
            sb.append("ResourceSetName: ").append(this.getResourceSetName()).append(",");
        }
        if (this.getResourceSetType() != null) {
            sb.append("ResourceSetType: ").append(this.getResourceSetType()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceSetRequest)) {
            return false;
        }
        UpdateResourceSetRequest other = (UpdateResourceSetRequest)obj;
        if (other.getResourceSetName() == null ^ this.getResourceSetName() == null) {
            return false;
        }
        if (other.getResourceSetName() != null && !other.getResourceSetName().equals(this.getResourceSetName())) {
            return false;
        }
        if (other.getResourceSetType() == null ^ this.getResourceSetType() == null) {
            return false;
        }
        if (other.getResourceSetType() != null && !other.getResourceSetType().equals(this.getResourceSetType())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceSetName() == null ? 0 : this.getResourceSetName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceSetType() == null ? 0 : this.getResourceSetType().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public UpdateResourceSetRequest clone() {
        return (UpdateResourceSetRequest)super.clone();
    }
}

