/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.s3control;

import javax.annotation.Generated;

import com.amazonaws.services.s3control.model.*;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.annotation.ThreadSafe;

import java.util.concurrent.ExecutorService;

/**
 * Client for accessing AWS S3 Control asynchronously. Each asynchronous method will return a Java Future object
 * representing the asynchronous operation; overloads which accept an {@code AsyncHandler} can be used to receive
 * notification when an asynchronous operation completes.
 * <p>
 * <p>
 * Amazon Web Services S3 Control provides access to Amazon S3 control plane actions.
 * </p>
 */
@ThreadSafe
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AWSS3ControlAsyncClient extends AWSS3ControlClient implements AWSS3ControlAsync {

    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    private final java.util.concurrent.ExecutorService executorService;

    public static AWSS3ControlAsyncClientBuilder asyncBuilder() {
        return AWSS3ControlAsyncClientBuilder.standard();
    }

    /**
     * Constructs a new asynchronous client to invoke service methods on AWS S3 Control using the specified parameters.
     *
     * @param asyncClientParams
     *        Object providing client parameters.
     */
    AWSS3ControlAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    /**
     * Constructs a new asynchronous client to invoke service methods on AWS S3 Control using the specified parameters.
     *
     * @param asyncClientParams
     *        Object providing client parameters.
     * @param endpointDiscoveryEnabled
     *        true will enable endpoint discovery if the service supports it.
     */
    AWSS3ControlAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super(asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    /**
     * Returns the executor service used by this client to execute async requests.
     *
     * @return The executor service used by this client to execute async requests.
     */
    public ExecutorService getExecutorService() {
        return executorService;
    }

    @Override
    public java.util.concurrent.Future<AssociateAccessGrantsIdentityCenterResult> associateAccessGrantsIdentityCenterAsync(
            AssociateAccessGrantsIdentityCenterRequest request) {

        return associateAccessGrantsIdentityCenterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateAccessGrantsIdentityCenterResult> associateAccessGrantsIdentityCenterAsync(
            final AssociateAccessGrantsIdentityCenterRequest request,
            final com.amazonaws.handlers.AsyncHandler<AssociateAccessGrantsIdentityCenterRequest, AssociateAccessGrantsIdentityCenterResult> asyncHandler) {
        final AssociateAccessGrantsIdentityCenterRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<AssociateAccessGrantsIdentityCenterResult>() {
            @Override
            public AssociateAccessGrantsIdentityCenterResult call() throws Exception {
                AssociateAccessGrantsIdentityCenterResult result = null;

                try {
                    result = executeAssociateAccessGrantsIdentityCenter(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantResult> createAccessGrantAsync(CreateAccessGrantRequest request) {

        return createAccessGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantResult> createAccessGrantAsync(final CreateAccessGrantRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateAccessGrantRequest, CreateAccessGrantResult> asyncHandler) {
        final CreateAccessGrantRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateAccessGrantResult>() {
            @Override
            public CreateAccessGrantResult call() throws Exception {
                CreateAccessGrantResult result = null;

                try {
                    result = executeCreateAccessGrant(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantsInstanceResult> createAccessGrantsInstanceAsync(CreateAccessGrantsInstanceRequest request) {

        return createAccessGrantsInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantsInstanceResult> createAccessGrantsInstanceAsync(final CreateAccessGrantsInstanceRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateAccessGrantsInstanceRequest, CreateAccessGrantsInstanceResult> asyncHandler) {
        final CreateAccessGrantsInstanceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateAccessGrantsInstanceResult>() {
            @Override
            public CreateAccessGrantsInstanceResult call() throws Exception {
                CreateAccessGrantsInstanceResult result = null;

                try {
                    result = executeCreateAccessGrantsInstance(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantsLocationResult> createAccessGrantsLocationAsync(CreateAccessGrantsLocationRequest request) {

        return createAccessGrantsLocationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessGrantsLocationResult> createAccessGrantsLocationAsync(final CreateAccessGrantsLocationRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateAccessGrantsLocationRequest, CreateAccessGrantsLocationResult> asyncHandler) {
        final CreateAccessGrantsLocationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateAccessGrantsLocationResult>() {
            @Override
            public CreateAccessGrantsLocationResult call() throws Exception {
                CreateAccessGrantsLocationResult result = null;

                try {
                    result = executeCreateAccessGrantsLocation(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPointResult> createAccessPointAsync(CreateAccessPointRequest request) {

        return createAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPointResult> createAccessPointAsync(final CreateAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateAccessPointRequest, CreateAccessPointResult> asyncHandler) {
        final CreateAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateAccessPointResult>() {
            @Override
            public CreateAccessPointResult call() throws Exception {
                CreateAccessPointResult result = null;

                try {
                    result = executeCreateAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPointForObjectLambdaResult> createAccessPointForObjectLambdaAsync(
            CreateAccessPointForObjectLambdaRequest request) {

        return createAccessPointForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAccessPointForObjectLambdaResult> createAccessPointForObjectLambdaAsync(
            final CreateAccessPointForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateAccessPointForObjectLambdaRequest, CreateAccessPointForObjectLambdaResult> asyncHandler) {
        final CreateAccessPointForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateAccessPointForObjectLambdaResult>() {
            @Override
            public CreateAccessPointForObjectLambdaResult call() throws Exception {
                CreateAccessPointForObjectLambdaResult result = null;

                try {
                    result = executeCreateAccessPointForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateBucketResult> createBucketAsync(CreateBucketRequest request) {

        return createBucketAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBucketResult> createBucketAsync(final CreateBucketRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateBucketRequest, CreateBucketResult> asyncHandler) {
        final CreateBucketRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateBucketResult>() {
            @Override
            public CreateBucketResult call() throws Exception {
                CreateBucketResult result = null;

                try {
                    result = executeCreateBucket(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateJobResult> createJobAsync(CreateJobRequest request) {

        return createJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateJobResult> createJobAsync(final CreateJobRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateJobResult>() {
            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;

                try {
                    result = executeCreateJob(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateMultiRegionAccessPointResult> createMultiRegionAccessPointAsync(CreateMultiRegionAccessPointRequest request) {

        return createMultiRegionAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateMultiRegionAccessPointResult> createMultiRegionAccessPointAsync(final CreateMultiRegionAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateMultiRegionAccessPointRequest, CreateMultiRegionAccessPointResult> asyncHandler) {
        final CreateMultiRegionAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateMultiRegionAccessPointResult>() {
            @Override
            public CreateMultiRegionAccessPointResult call() throws Exception {
                CreateMultiRegionAccessPointResult result = null;

                try {
                    result = executeCreateMultiRegionAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<CreateStorageLensGroupResult> createStorageLensGroupAsync(CreateStorageLensGroupRequest request) {

        return createStorageLensGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateStorageLensGroupResult> createStorageLensGroupAsync(final CreateStorageLensGroupRequest request,
            final com.amazonaws.handlers.AsyncHandler<CreateStorageLensGroupRequest, CreateStorageLensGroupResult> asyncHandler) {
        final CreateStorageLensGroupRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<CreateStorageLensGroupResult>() {
            @Override
            public CreateStorageLensGroupResult call() throws Exception {
                CreateStorageLensGroupResult result = null;

                try {
                    result = executeCreateStorageLensGroup(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantResult> deleteAccessGrantAsync(DeleteAccessGrantRequest request) {

        return deleteAccessGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantResult> deleteAccessGrantAsync(final DeleteAccessGrantRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessGrantRequest, DeleteAccessGrantResult> asyncHandler) {
        final DeleteAccessGrantRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessGrantResult>() {
            @Override
            public DeleteAccessGrantResult call() throws Exception {
                DeleteAccessGrantResult result = null;

                try {
                    result = executeDeleteAccessGrant(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsInstanceResult> deleteAccessGrantsInstanceAsync(DeleteAccessGrantsInstanceRequest request) {

        return deleteAccessGrantsInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsInstanceResult> deleteAccessGrantsInstanceAsync(final DeleteAccessGrantsInstanceRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessGrantsInstanceRequest, DeleteAccessGrantsInstanceResult> asyncHandler) {
        final DeleteAccessGrantsInstanceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessGrantsInstanceResult>() {
            @Override
            public DeleteAccessGrantsInstanceResult call() throws Exception {
                DeleteAccessGrantsInstanceResult result = null;

                try {
                    result = executeDeleteAccessGrantsInstance(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsInstanceResourcePolicyResult> deleteAccessGrantsInstanceResourcePolicyAsync(
            DeleteAccessGrantsInstanceResourcePolicyRequest request) {

        return deleteAccessGrantsInstanceResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsInstanceResourcePolicyResult> deleteAccessGrantsInstanceResourcePolicyAsync(
            final DeleteAccessGrantsInstanceResourcePolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessGrantsInstanceResourcePolicyRequest, DeleteAccessGrantsInstanceResourcePolicyResult> asyncHandler) {
        final DeleteAccessGrantsInstanceResourcePolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessGrantsInstanceResourcePolicyResult>() {
            @Override
            public DeleteAccessGrantsInstanceResourcePolicyResult call() throws Exception {
                DeleteAccessGrantsInstanceResourcePolicyResult result = null;

                try {
                    result = executeDeleteAccessGrantsInstanceResourcePolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsLocationResult> deleteAccessGrantsLocationAsync(DeleteAccessGrantsLocationRequest request) {

        return deleteAccessGrantsLocationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessGrantsLocationResult> deleteAccessGrantsLocationAsync(final DeleteAccessGrantsLocationRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessGrantsLocationRequest, DeleteAccessGrantsLocationResult> asyncHandler) {
        final DeleteAccessGrantsLocationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessGrantsLocationResult>() {
            @Override
            public DeleteAccessGrantsLocationResult call() throws Exception {
                DeleteAccessGrantsLocationResult result = null;

                try {
                    result = executeDeleteAccessGrantsLocation(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointResult> deleteAccessPointAsync(DeleteAccessPointRequest request) {

        return deleteAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointResult> deleteAccessPointAsync(final DeleteAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessPointRequest, DeleteAccessPointResult> asyncHandler) {
        final DeleteAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessPointResult>() {
            @Override
            public DeleteAccessPointResult call() throws Exception {
                DeleteAccessPointResult result = null;

                try {
                    result = executeDeleteAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointForObjectLambdaResult> deleteAccessPointForObjectLambdaAsync(
            DeleteAccessPointForObjectLambdaRequest request) {

        return deleteAccessPointForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointForObjectLambdaResult> deleteAccessPointForObjectLambdaAsync(
            final DeleteAccessPointForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessPointForObjectLambdaRequest, DeleteAccessPointForObjectLambdaResult> asyncHandler) {
        final DeleteAccessPointForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessPointForObjectLambdaResult>() {
            @Override
            public DeleteAccessPointForObjectLambdaResult call() throws Exception {
                DeleteAccessPointForObjectLambdaResult result = null;

                try {
                    result = executeDeleteAccessPointForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointPolicyResult> deleteAccessPointPolicyAsync(DeleteAccessPointPolicyRequest request) {

        return deleteAccessPointPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointPolicyResult> deleteAccessPointPolicyAsync(final DeleteAccessPointPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessPointPolicyRequest, DeleteAccessPointPolicyResult> asyncHandler) {
        final DeleteAccessPointPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessPointPolicyResult>() {
            @Override
            public DeleteAccessPointPolicyResult call() throws Exception {
                DeleteAccessPointPolicyResult result = null;

                try {
                    result = executeDeleteAccessPointPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointPolicyForObjectLambdaResult> deleteAccessPointPolicyForObjectLambdaAsync(
            DeleteAccessPointPolicyForObjectLambdaRequest request) {

        return deleteAccessPointPolicyForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAccessPointPolicyForObjectLambdaResult> deleteAccessPointPolicyForObjectLambdaAsync(
            final DeleteAccessPointPolicyForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteAccessPointPolicyForObjectLambdaRequest, DeleteAccessPointPolicyForObjectLambdaResult> asyncHandler) {
        final DeleteAccessPointPolicyForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteAccessPointPolicyForObjectLambdaResult>() {
            @Override
            public DeleteAccessPointPolicyForObjectLambdaResult call() throws Exception {
                DeleteAccessPointPolicyForObjectLambdaResult result = null;

                try {
                    result = executeDeleteAccessPointPolicyForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketResult> deleteBucketAsync(DeleteBucketRequest request) {

        return deleteBucketAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketResult> deleteBucketAsync(final DeleteBucketRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteBucketRequest, DeleteBucketResult> asyncHandler) {
        final DeleteBucketRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteBucketResult>() {
            @Override
            public DeleteBucketResult call() throws Exception {
                DeleteBucketResult result = null;

                try {
                    result = executeDeleteBucket(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketLifecycleConfigurationResult> deleteBucketLifecycleConfigurationAsync(
            DeleteBucketLifecycleConfigurationRequest request) {

        return deleteBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketLifecycleConfigurationResult> deleteBucketLifecycleConfigurationAsync(
            final DeleteBucketLifecycleConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteBucketLifecycleConfigurationRequest, DeleteBucketLifecycleConfigurationResult> asyncHandler) {
        final DeleteBucketLifecycleConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteBucketLifecycleConfigurationResult>() {
            @Override
            public DeleteBucketLifecycleConfigurationResult call() throws Exception {
                DeleteBucketLifecycleConfigurationResult result = null;

                try {
                    result = executeDeleteBucketLifecycleConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketPolicyResult> deleteBucketPolicyAsync(DeleteBucketPolicyRequest request) {

        return deleteBucketPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketPolicyResult> deleteBucketPolicyAsync(final DeleteBucketPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteBucketPolicyRequest, DeleteBucketPolicyResult> asyncHandler) {
        final DeleteBucketPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteBucketPolicyResult>() {
            @Override
            public DeleteBucketPolicyResult call() throws Exception {
                DeleteBucketPolicyResult result = null;

                try {
                    result = executeDeleteBucketPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketReplicationResult> deleteBucketReplicationAsync(DeleteBucketReplicationRequest request) {

        return deleteBucketReplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketReplicationResult> deleteBucketReplicationAsync(final DeleteBucketReplicationRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteBucketReplicationRequest, DeleteBucketReplicationResult> asyncHandler) {
        final DeleteBucketReplicationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteBucketReplicationResult>() {
            @Override
            public DeleteBucketReplicationResult call() throws Exception {
                DeleteBucketReplicationResult result = null;

                try {
                    result = executeDeleteBucketReplication(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketTaggingResult> deleteBucketTaggingAsync(DeleteBucketTaggingRequest request) {

        return deleteBucketTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBucketTaggingResult> deleteBucketTaggingAsync(final DeleteBucketTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteBucketTaggingRequest, DeleteBucketTaggingResult> asyncHandler) {
        final DeleteBucketTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteBucketTaggingResult>() {
            @Override
            public DeleteBucketTaggingResult call() throws Exception {
                DeleteBucketTaggingResult result = null;

                try {
                    result = executeDeleteBucketTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteJobTaggingResult> deleteJobTaggingAsync(DeleteJobTaggingRequest request) {

        return deleteJobTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteJobTaggingResult> deleteJobTaggingAsync(final DeleteJobTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteJobTaggingRequest, DeleteJobTaggingResult> asyncHandler) {
        final DeleteJobTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteJobTaggingResult>() {
            @Override
            public DeleteJobTaggingResult call() throws Exception {
                DeleteJobTaggingResult result = null;

                try {
                    result = executeDeleteJobTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteMultiRegionAccessPointResult> deleteMultiRegionAccessPointAsync(DeleteMultiRegionAccessPointRequest request) {

        return deleteMultiRegionAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteMultiRegionAccessPointResult> deleteMultiRegionAccessPointAsync(final DeleteMultiRegionAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteMultiRegionAccessPointRequest, DeleteMultiRegionAccessPointResult> asyncHandler) {
        final DeleteMultiRegionAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteMultiRegionAccessPointResult>() {
            @Override
            public DeleteMultiRegionAccessPointResult call() throws Exception {
                DeleteMultiRegionAccessPointResult result = null;

                try {
                    result = executeDeleteMultiRegionAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(DeletePublicAccessBlockRequest request) {

        return deletePublicAccessBlockAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePublicAccessBlockResult> deletePublicAccessBlockAsync(final DeletePublicAccessBlockRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeletePublicAccessBlockRequest, DeletePublicAccessBlockResult> asyncHandler) {
        final DeletePublicAccessBlockRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeletePublicAccessBlockResult>() {
            @Override
            public DeletePublicAccessBlockResult call() throws Exception {
                DeletePublicAccessBlockResult result = null;

                try {
                    result = executeDeletePublicAccessBlock(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensConfigurationResult> deleteStorageLensConfigurationAsync(DeleteStorageLensConfigurationRequest request) {

        return deleteStorageLensConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensConfigurationResult> deleteStorageLensConfigurationAsync(
            final DeleteStorageLensConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteStorageLensConfigurationRequest, DeleteStorageLensConfigurationResult> asyncHandler) {
        final DeleteStorageLensConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteStorageLensConfigurationResult>() {
            @Override
            public DeleteStorageLensConfigurationResult call() throws Exception {
                DeleteStorageLensConfigurationResult result = null;

                try {
                    result = executeDeleteStorageLensConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensConfigurationTaggingResult> deleteStorageLensConfigurationTaggingAsync(
            DeleteStorageLensConfigurationTaggingRequest request) {

        return deleteStorageLensConfigurationTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensConfigurationTaggingResult> deleteStorageLensConfigurationTaggingAsync(
            final DeleteStorageLensConfigurationTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteStorageLensConfigurationTaggingRequest, DeleteStorageLensConfigurationTaggingResult> asyncHandler) {
        final DeleteStorageLensConfigurationTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteStorageLensConfigurationTaggingResult>() {
            @Override
            public DeleteStorageLensConfigurationTaggingResult call() throws Exception {
                DeleteStorageLensConfigurationTaggingResult result = null;

                try {
                    result = executeDeleteStorageLensConfigurationTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensGroupResult> deleteStorageLensGroupAsync(DeleteStorageLensGroupRequest request) {

        return deleteStorageLensGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteStorageLensGroupResult> deleteStorageLensGroupAsync(final DeleteStorageLensGroupRequest request,
            final com.amazonaws.handlers.AsyncHandler<DeleteStorageLensGroupRequest, DeleteStorageLensGroupResult> asyncHandler) {
        final DeleteStorageLensGroupRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DeleteStorageLensGroupResult>() {
            @Override
            public DeleteStorageLensGroupResult call() throws Exception {
                DeleteStorageLensGroupResult result = null;

                try {
                    result = executeDeleteStorageLensGroup(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request) {

        return describeJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeJobResult> describeJobAsync(final DescribeJobRequest request,
            final com.amazonaws.handlers.AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) {
        final DescribeJobRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DescribeJobResult>() {
            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result = null;

                try {
                    result = executeDescribeJob(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DescribeMultiRegionAccessPointOperationResult> describeMultiRegionAccessPointOperationAsync(
            DescribeMultiRegionAccessPointOperationRequest request) {

        return describeMultiRegionAccessPointOperationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeMultiRegionAccessPointOperationResult> describeMultiRegionAccessPointOperationAsync(
            final DescribeMultiRegionAccessPointOperationRequest request,
            final com.amazonaws.handlers.AsyncHandler<DescribeMultiRegionAccessPointOperationRequest, DescribeMultiRegionAccessPointOperationResult> asyncHandler) {
        final DescribeMultiRegionAccessPointOperationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DescribeMultiRegionAccessPointOperationResult>() {
            @Override
            public DescribeMultiRegionAccessPointOperationResult call() throws Exception {
                DescribeMultiRegionAccessPointOperationResult result = null;

                try {
                    result = executeDescribeMultiRegionAccessPointOperation(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<DissociateAccessGrantsIdentityCenterResult> dissociateAccessGrantsIdentityCenterAsync(
            DissociateAccessGrantsIdentityCenterRequest request) {

        return dissociateAccessGrantsIdentityCenterAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DissociateAccessGrantsIdentityCenterResult> dissociateAccessGrantsIdentityCenterAsync(
            final DissociateAccessGrantsIdentityCenterRequest request,
            final com.amazonaws.handlers.AsyncHandler<DissociateAccessGrantsIdentityCenterRequest, DissociateAccessGrantsIdentityCenterResult> asyncHandler) {
        final DissociateAccessGrantsIdentityCenterRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<DissociateAccessGrantsIdentityCenterResult>() {
            @Override
            public DissociateAccessGrantsIdentityCenterResult call() throws Exception {
                DissociateAccessGrantsIdentityCenterResult result = null;

                try {
                    result = executeDissociateAccessGrantsIdentityCenter(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantResult> getAccessGrantAsync(GetAccessGrantRequest request) {

        return getAccessGrantAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantResult> getAccessGrantAsync(final GetAccessGrantRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessGrantRequest, GetAccessGrantResult> asyncHandler) {
        final GetAccessGrantRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessGrantResult>() {
            @Override
            public GetAccessGrantResult call() throws Exception {
                GetAccessGrantResult result = null;

                try {
                    result = executeGetAccessGrant(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceResult> getAccessGrantsInstanceAsync(GetAccessGrantsInstanceRequest request) {

        return getAccessGrantsInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceResult> getAccessGrantsInstanceAsync(final GetAccessGrantsInstanceRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessGrantsInstanceRequest, GetAccessGrantsInstanceResult> asyncHandler) {
        final GetAccessGrantsInstanceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessGrantsInstanceResult>() {
            @Override
            public GetAccessGrantsInstanceResult call() throws Exception {
                GetAccessGrantsInstanceResult result = null;

                try {
                    result = executeGetAccessGrantsInstance(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceForPrefixResult> getAccessGrantsInstanceForPrefixAsync(
            GetAccessGrantsInstanceForPrefixRequest request) {

        return getAccessGrantsInstanceForPrefixAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceForPrefixResult> getAccessGrantsInstanceForPrefixAsync(
            final GetAccessGrantsInstanceForPrefixRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessGrantsInstanceForPrefixRequest, GetAccessGrantsInstanceForPrefixResult> asyncHandler) {
        final GetAccessGrantsInstanceForPrefixRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessGrantsInstanceForPrefixResult>() {
            @Override
            public GetAccessGrantsInstanceForPrefixResult call() throws Exception {
                GetAccessGrantsInstanceForPrefixResult result = null;

                try {
                    result = executeGetAccessGrantsInstanceForPrefix(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceResourcePolicyResult> getAccessGrantsInstanceResourcePolicyAsync(
            GetAccessGrantsInstanceResourcePolicyRequest request) {

        return getAccessGrantsInstanceResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsInstanceResourcePolicyResult> getAccessGrantsInstanceResourcePolicyAsync(
            final GetAccessGrantsInstanceResourcePolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessGrantsInstanceResourcePolicyRequest, GetAccessGrantsInstanceResourcePolicyResult> asyncHandler) {
        final GetAccessGrantsInstanceResourcePolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessGrantsInstanceResourcePolicyResult>() {
            @Override
            public GetAccessGrantsInstanceResourcePolicyResult call() throws Exception {
                GetAccessGrantsInstanceResourcePolicyResult result = null;

                try {
                    result = executeGetAccessGrantsInstanceResourcePolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsLocationResult> getAccessGrantsLocationAsync(GetAccessGrantsLocationRequest request) {

        return getAccessGrantsLocationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessGrantsLocationResult> getAccessGrantsLocationAsync(final GetAccessGrantsLocationRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessGrantsLocationRequest, GetAccessGrantsLocationResult> asyncHandler) {
        final GetAccessGrantsLocationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessGrantsLocationResult>() {
            @Override
            public GetAccessGrantsLocationResult call() throws Exception {
                GetAccessGrantsLocationResult result = null;

                try {
                    result = executeGetAccessGrantsLocation(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointResult> getAccessPointAsync(GetAccessPointRequest request) {

        return getAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointResult> getAccessPointAsync(final GetAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointRequest, GetAccessPointResult> asyncHandler) {
        final GetAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointResult>() {
            @Override
            public GetAccessPointResult call() throws Exception {
                GetAccessPointResult result = null;

                try {
                    result = executeGetAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointConfigurationForObjectLambdaResult> getAccessPointConfigurationForObjectLambdaAsync(
            GetAccessPointConfigurationForObjectLambdaRequest request) {

        return getAccessPointConfigurationForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointConfigurationForObjectLambdaResult> getAccessPointConfigurationForObjectLambdaAsync(
            final GetAccessPointConfigurationForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointConfigurationForObjectLambdaRequest, GetAccessPointConfigurationForObjectLambdaResult> asyncHandler) {
        final GetAccessPointConfigurationForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointConfigurationForObjectLambdaResult>() {
            @Override
            public GetAccessPointConfigurationForObjectLambdaResult call() throws Exception {
                GetAccessPointConfigurationForObjectLambdaResult result = null;

                try {
                    result = executeGetAccessPointConfigurationForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointForObjectLambdaResult> getAccessPointForObjectLambdaAsync(GetAccessPointForObjectLambdaRequest request) {

        return getAccessPointForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointForObjectLambdaResult> getAccessPointForObjectLambdaAsync(
            final GetAccessPointForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointForObjectLambdaRequest, GetAccessPointForObjectLambdaResult> asyncHandler) {
        final GetAccessPointForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointForObjectLambdaResult>() {
            @Override
            public GetAccessPointForObjectLambdaResult call() throws Exception {
                GetAccessPointForObjectLambdaResult result = null;

                try {
                    result = executeGetAccessPointForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyResult> getAccessPointPolicyAsync(GetAccessPointPolicyRequest request) {

        return getAccessPointPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyResult> getAccessPointPolicyAsync(final GetAccessPointPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointPolicyRequest, GetAccessPointPolicyResult> asyncHandler) {
        final GetAccessPointPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointPolicyResult>() {
            @Override
            public GetAccessPointPolicyResult call() throws Exception {
                GetAccessPointPolicyResult result = null;

                try {
                    result = executeGetAccessPointPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyForObjectLambdaResult> getAccessPointPolicyForObjectLambdaAsync(
            GetAccessPointPolicyForObjectLambdaRequest request) {

        return getAccessPointPolicyForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyForObjectLambdaResult> getAccessPointPolicyForObjectLambdaAsync(
            final GetAccessPointPolicyForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointPolicyForObjectLambdaRequest, GetAccessPointPolicyForObjectLambdaResult> asyncHandler) {
        final GetAccessPointPolicyForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointPolicyForObjectLambdaResult>() {
            @Override
            public GetAccessPointPolicyForObjectLambdaResult call() throws Exception {
                GetAccessPointPolicyForObjectLambdaResult result = null;

                try {
                    result = executeGetAccessPointPolicyForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyStatusResult> getAccessPointPolicyStatusAsync(GetAccessPointPolicyStatusRequest request) {

        return getAccessPointPolicyStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyStatusResult> getAccessPointPolicyStatusAsync(final GetAccessPointPolicyStatusRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointPolicyStatusRequest, GetAccessPointPolicyStatusResult> asyncHandler) {
        final GetAccessPointPolicyStatusRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointPolicyStatusResult>() {
            @Override
            public GetAccessPointPolicyStatusResult call() throws Exception {
                GetAccessPointPolicyStatusResult result = null;

                try {
                    result = executeGetAccessPointPolicyStatus(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyStatusForObjectLambdaResult> getAccessPointPolicyStatusForObjectLambdaAsync(
            GetAccessPointPolicyStatusForObjectLambdaRequest request) {

        return getAccessPointPolicyStatusForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAccessPointPolicyStatusForObjectLambdaResult> getAccessPointPolicyStatusForObjectLambdaAsync(
            final GetAccessPointPolicyStatusForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetAccessPointPolicyStatusForObjectLambdaRequest, GetAccessPointPolicyStatusForObjectLambdaResult> asyncHandler) {
        final GetAccessPointPolicyStatusForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetAccessPointPolicyStatusForObjectLambdaResult>() {
            @Override
            public GetAccessPointPolicyStatusForObjectLambdaResult call() throws Exception {
                GetAccessPointPolicyStatusForObjectLambdaResult result = null;

                try {
                    result = executeGetAccessPointPolicyStatusForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketResult> getBucketAsync(GetBucketRequest request) {

        return getBucketAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketResult> getBucketAsync(final GetBucketRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketRequest, GetBucketResult> asyncHandler) {
        final GetBucketRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketResult>() {
            @Override
            public GetBucketResult call() throws Exception {
                GetBucketResult result = null;

                try {
                    result = executeGetBucket(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketLifecycleConfigurationResult> getBucketLifecycleConfigurationAsync(
            GetBucketLifecycleConfigurationRequest request) {

        return getBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketLifecycleConfigurationResult> getBucketLifecycleConfigurationAsync(
            final GetBucketLifecycleConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketLifecycleConfigurationRequest, GetBucketLifecycleConfigurationResult> asyncHandler) {
        final GetBucketLifecycleConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketLifecycleConfigurationResult>() {
            @Override
            public GetBucketLifecycleConfigurationResult call() throws Exception {
                GetBucketLifecycleConfigurationResult result = null;

                try {
                    result = executeGetBucketLifecycleConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketPolicyResult> getBucketPolicyAsync(GetBucketPolicyRequest request) {

        return getBucketPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketPolicyResult> getBucketPolicyAsync(final GetBucketPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketPolicyRequest, GetBucketPolicyResult> asyncHandler) {
        final GetBucketPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketPolicyResult>() {
            @Override
            public GetBucketPolicyResult call() throws Exception {
                GetBucketPolicyResult result = null;

                try {
                    result = executeGetBucketPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketReplicationResult> getBucketReplicationAsync(GetBucketReplicationRequest request) {

        return getBucketReplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketReplicationResult> getBucketReplicationAsync(final GetBucketReplicationRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketReplicationRequest, GetBucketReplicationResult> asyncHandler) {
        final GetBucketReplicationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketReplicationResult>() {
            @Override
            public GetBucketReplicationResult call() throws Exception {
                GetBucketReplicationResult result = null;

                try {
                    result = executeGetBucketReplication(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketTaggingResult> getBucketTaggingAsync(GetBucketTaggingRequest request) {

        return getBucketTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketTaggingResult> getBucketTaggingAsync(final GetBucketTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketTaggingRequest, GetBucketTaggingResult> asyncHandler) {
        final GetBucketTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketTaggingResult>() {
            @Override
            public GetBucketTaggingResult call() throws Exception {
                GetBucketTaggingResult result = null;

                try {
                    result = executeGetBucketTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetBucketVersioningResult> getBucketVersioningAsync(GetBucketVersioningRequest request) {

        return getBucketVersioningAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBucketVersioningResult> getBucketVersioningAsync(final GetBucketVersioningRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetBucketVersioningRequest, GetBucketVersioningResult> asyncHandler) {
        final GetBucketVersioningRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetBucketVersioningResult>() {
            @Override
            public GetBucketVersioningResult call() throws Exception {
                GetBucketVersioningResult result = null;

                try {
                    result = executeGetBucketVersioning(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetDataAccessResult> getDataAccessAsync(GetDataAccessRequest request) {

        return getDataAccessAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDataAccessResult> getDataAccessAsync(final GetDataAccessRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetDataAccessRequest, GetDataAccessResult> asyncHandler) {
        final GetDataAccessRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetDataAccessResult>() {
            @Override
            public GetDataAccessResult call() throws Exception {
                GetDataAccessResult result = null;

                try {
                    result = executeGetDataAccess(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetJobTaggingResult> getJobTaggingAsync(GetJobTaggingRequest request) {

        return getJobTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetJobTaggingResult> getJobTaggingAsync(final GetJobTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetJobTaggingRequest, GetJobTaggingResult> asyncHandler) {
        final GetJobTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetJobTaggingResult>() {
            @Override
            public GetJobTaggingResult call() throws Exception {
                GetJobTaggingResult result = null;

                try {
                    result = executeGetJobTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointResult> getMultiRegionAccessPointAsync(GetMultiRegionAccessPointRequest request) {

        return getMultiRegionAccessPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointResult> getMultiRegionAccessPointAsync(final GetMultiRegionAccessPointRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetMultiRegionAccessPointRequest, GetMultiRegionAccessPointResult> asyncHandler) {
        final GetMultiRegionAccessPointRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetMultiRegionAccessPointResult>() {
            @Override
            public GetMultiRegionAccessPointResult call() throws Exception {
                GetMultiRegionAccessPointResult result = null;

                try {
                    result = executeGetMultiRegionAccessPoint(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointPolicyResult> getMultiRegionAccessPointPolicyAsync(
            GetMultiRegionAccessPointPolicyRequest request) {

        return getMultiRegionAccessPointPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointPolicyResult> getMultiRegionAccessPointPolicyAsync(
            final GetMultiRegionAccessPointPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetMultiRegionAccessPointPolicyRequest, GetMultiRegionAccessPointPolicyResult> asyncHandler) {
        final GetMultiRegionAccessPointPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetMultiRegionAccessPointPolicyResult>() {
            @Override
            public GetMultiRegionAccessPointPolicyResult call() throws Exception {
                GetMultiRegionAccessPointPolicyResult result = null;

                try {
                    result = executeGetMultiRegionAccessPointPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointPolicyStatusResult> getMultiRegionAccessPointPolicyStatusAsync(
            GetMultiRegionAccessPointPolicyStatusRequest request) {

        return getMultiRegionAccessPointPolicyStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointPolicyStatusResult> getMultiRegionAccessPointPolicyStatusAsync(
            final GetMultiRegionAccessPointPolicyStatusRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetMultiRegionAccessPointPolicyStatusRequest, GetMultiRegionAccessPointPolicyStatusResult> asyncHandler) {
        final GetMultiRegionAccessPointPolicyStatusRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetMultiRegionAccessPointPolicyStatusResult>() {
            @Override
            public GetMultiRegionAccessPointPolicyStatusResult call() throws Exception {
                GetMultiRegionAccessPointPolicyStatusResult result = null;

                try {
                    result = executeGetMultiRegionAccessPointPolicyStatus(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointRoutesResult> getMultiRegionAccessPointRoutesAsync(
            GetMultiRegionAccessPointRoutesRequest request) {

        return getMultiRegionAccessPointRoutesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetMultiRegionAccessPointRoutesResult> getMultiRegionAccessPointRoutesAsync(
            final GetMultiRegionAccessPointRoutesRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetMultiRegionAccessPointRoutesRequest, GetMultiRegionAccessPointRoutesResult> asyncHandler) {
        final GetMultiRegionAccessPointRoutesRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetMultiRegionAccessPointRoutesResult>() {
            @Override
            public GetMultiRegionAccessPointRoutesResult call() throws Exception {
                GetMultiRegionAccessPointRoutesResult result = null;

                try {
                    result = executeGetMultiRegionAccessPointRoutes(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(GetPublicAccessBlockRequest request) {

        return getPublicAccessBlockAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPublicAccessBlockResult> getPublicAccessBlockAsync(final GetPublicAccessBlockRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetPublicAccessBlockRequest, GetPublicAccessBlockResult> asyncHandler) {
        final GetPublicAccessBlockRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetPublicAccessBlockResult>() {
            @Override
            public GetPublicAccessBlockResult call() throws Exception {
                GetPublicAccessBlockResult result = null;

                try {
                    result = executeGetPublicAccessBlock(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensConfigurationResult> getStorageLensConfigurationAsync(GetStorageLensConfigurationRequest request) {

        return getStorageLensConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensConfigurationResult> getStorageLensConfigurationAsync(final GetStorageLensConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetStorageLensConfigurationRequest, GetStorageLensConfigurationResult> asyncHandler) {
        final GetStorageLensConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetStorageLensConfigurationResult>() {
            @Override
            public GetStorageLensConfigurationResult call() throws Exception {
                GetStorageLensConfigurationResult result = null;

                try {
                    result = executeGetStorageLensConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensConfigurationTaggingResult> getStorageLensConfigurationTaggingAsync(
            GetStorageLensConfigurationTaggingRequest request) {

        return getStorageLensConfigurationTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensConfigurationTaggingResult> getStorageLensConfigurationTaggingAsync(
            final GetStorageLensConfigurationTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetStorageLensConfigurationTaggingRequest, GetStorageLensConfigurationTaggingResult> asyncHandler) {
        final GetStorageLensConfigurationTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetStorageLensConfigurationTaggingResult>() {
            @Override
            public GetStorageLensConfigurationTaggingResult call() throws Exception {
                GetStorageLensConfigurationTaggingResult result = null;

                try {
                    result = executeGetStorageLensConfigurationTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensGroupResult> getStorageLensGroupAsync(GetStorageLensGroupRequest request) {

        return getStorageLensGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetStorageLensGroupResult> getStorageLensGroupAsync(final GetStorageLensGroupRequest request,
            final com.amazonaws.handlers.AsyncHandler<GetStorageLensGroupRequest, GetStorageLensGroupResult> asyncHandler) {
        final GetStorageLensGroupRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<GetStorageLensGroupResult>() {
            @Override
            public GetStorageLensGroupResult call() throws Exception {
                GetStorageLensGroupResult result = null;

                try {
                    result = executeGetStorageLensGroup(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsResult> listAccessGrantsAsync(ListAccessGrantsRequest request) {

        return listAccessGrantsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsResult> listAccessGrantsAsync(final ListAccessGrantsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListAccessGrantsRequest, ListAccessGrantsResult> asyncHandler) {
        final ListAccessGrantsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListAccessGrantsResult>() {
            @Override
            public ListAccessGrantsResult call() throws Exception {
                ListAccessGrantsResult result = null;

                try {
                    result = executeListAccessGrants(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsInstancesResult> listAccessGrantsInstancesAsync(ListAccessGrantsInstancesRequest request) {

        return listAccessGrantsInstancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsInstancesResult> listAccessGrantsInstancesAsync(final ListAccessGrantsInstancesRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListAccessGrantsInstancesRequest, ListAccessGrantsInstancesResult> asyncHandler) {
        final ListAccessGrantsInstancesRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListAccessGrantsInstancesResult>() {
            @Override
            public ListAccessGrantsInstancesResult call() throws Exception {
                ListAccessGrantsInstancesResult result = null;

                try {
                    result = executeListAccessGrantsInstances(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsLocationsResult> listAccessGrantsLocationsAsync(ListAccessGrantsLocationsRequest request) {

        return listAccessGrantsLocationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessGrantsLocationsResult> listAccessGrantsLocationsAsync(final ListAccessGrantsLocationsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListAccessGrantsLocationsRequest, ListAccessGrantsLocationsResult> asyncHandler) {
        final ListAccessGrantsLocationsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListAccessGrantsLocationsResult>() {
            @Override
            public ListAccessGrantsLocationsResult call() throws Exception {
                ListAccessGrantsLocationsResult result = null;

                try {
                    result = executeListAccessGrantsLocations(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListAccessPointsResult> listAccessPointsAsync(ListAccessPointsRequest request) {

        return listAccessPointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessPointsResult> listAccessPointsAsync(final ListAccessPointsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListAccessPointsRequest, ListAccessPointsResult> asyncHandler) {
        final ListAccessPointsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListAccessPointsResult>() {
            @Override
            public ListAccessPointsResult call() throws Exception {
                ListAccessPointsResult result = null;

                try {
                    result = executeListAccessPoints(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListAccessPointsForObjectLambdaResult> listAccessPointsForObjectLambdaAsync(
            ListAccessPointsForObjectLambdaRequest request) {

        return listAccessPointsForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAccessPointsForObjectLambdaResult> listAccessPointsForObjectLambdaAsync(
            final ListAccessPointsForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListAccessPointsForObjectLambdaRequest, ListAccessPointsForObjectLambdaResult> asyncHandler) {
        final ListAccessPointsForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListAccessPointsForObjectLambdaResult>() {
            @Override
            public ListAccessPointsForObjectLambdaResult call() throws Exception {
                ListAccessPointsForObjectLambdaResult result = null;

                try {
                    result = executeListAccessPointsForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {

        return listJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListJobsResult> listJobsAsync(final ListJobsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        final ListJobsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListJobsResult>() {
            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result = null;

                try {
                    result = executeListJobs(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListMultiRegionAccessPointsResult> listMultiRegionAccessPointsAsync(ListMultiRegionAccessPointsRequest request) {

        return listMultiRegionAccessPointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListMultiRegionAccessPointsResult> listMultiRegionAccessPointsAsync(final ListMultiRegionAccessPointsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListMultiRegionAccessPointsRequest, ListMultiRegionAccessPointsResult> asyncHandler) {
        final ListMultiRegionAccessPointsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListMultiRegionAccessPointsResult>() {
            @Override
            public ListMultiRegionAccessPointsResult call() throws Exception {
                ListMultiRegionAccessPointsResult result = null;

                try {
                    result = executeListMultiRegionAccessPoints(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListRegionalBucketsResult> listRegionalBucketsAsync(ListRegionalBucketsRequest request) {

        return listRegionalBucketsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRegionalBucketsResult> listRegionalBucketsAsync(final ListRegionalBucketsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListRegionalBucketsRequest, ListRegionalBucketsResult> asyncHandler) {
        final ListRegionalBucketsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListRegionalBucketsResult>() {
            @Override
            public ListRegionalBucketsResult call() throws Exception {
                ListRegionalBucketsResult result = null;

                try {
                    result = executeListRegionalBuckets(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListStorageLensConfigurationsResult> listStorageLensConfigurationsAsync(ListStorageLensConfigurationsRequest request) {

        return listStorageLensConfigurationsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStorageLensConfigurationsResult> listStorageLensConfigurationsAsync(
            final ListStorageLensConfigurationsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListStorageLensConfigurationsRequest, ListStorageLensConfigurationsResult> asyncHandler) {
        final ListStorageLensConfigurationsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListStorageLensConfigurationsResult>() {
            @Override
            public ListStorageLensConfigurationsResult call() throws Exception {
                ListStorageLensConfigurationsResult result = null;

                try {
                    result = executeListStorageLensConfigurations(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListStorageLensGroupsResult> listStorageLensGroupsAsync(ListStorageLensGroupsRequest request) {

        return listStorageLensGroupsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListStorageLensGroupsResult> listStorageLensGroupsAsync(final ListStorageLensGroupsRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListStorageLensGroupsRequest, ListStorageLensGroupsResult> asyncHandler) {
        final ListStorageLensGroupsRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListStorageLensGroupsResult>() {
            @Override
            public ListStorageLensGroupsResult call() throws Exception {
                ListStorageLensGroupsResult result = null;

                try {
                    result = executeListStorageLensGroups(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(final ListTagsForResourceRequest request,
            final com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<ListTagsForResourceResult>() {
            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;

                try {
                    result = executeListTagsForResource(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutAccessGrantsInstanceResourcePolicyResult> putAccessGrantsInstanceResourcePolicyAsync(
            PutAccessGrantsInstanceResourcePolicyRequest request) {

        return putAccessGrantsInstanceResourcePolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutAccessGrantsInstanceResourcePolicyResult> putAccessGrantsInstanceResourcePolicyAsync(
            final PutAccessGrantsInstanceResourcePolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutAccessGrantsInstanceResourcePolicyRequest, PutAccessGrantsInstanceResourcePolicyResult> asyncHandler) {
        final PutAccessGrantsInstanceResourcePolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutAccessGrantsInstanceResourcePolicyResult>() {
            @Override
            public PutAccessGrantsInstanceResourcePolicyResult call() throws Exception {
                PutAccessGrantsInstanceResourcePolicyResult result = null;

                try {
                    result = executePutAccessGrantsInstanceResourcePolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointConfigurationForObjectLambdaResult> putAccessPointConfigurationForObjectLambdaAsync(
            PutAccessPointConfigurationForObjectLambdaRequest request) {

        return putAccessPointConfigurationForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointConfigurationForObjectLambdaResult> putAccessPointConfigurationForObjectLambdaAsync(
            final PutAccessPointConfigurationForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutAccessPointConfigurationForObjectLambdaRequest, PutAccessPointConfigurationForObjectLambdaResult> asyncHandler) {
        final PutAccessPointConfigurationForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutAccessPointConfigurationForObjectLambdaResult>() {
            @Override
            public PutAccessPointConfigurationForObjectLambdaResult call() throws Exception {
                PutAccessPointConfigurationForObjectLambdaResult result = null;

                try {
                    result = executePutAccessPointConfigurationForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointPolicyResult> putAccessPointPolicyAsync(PutAccessPointPolicyRequest request) {

        return putAccessPointPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointPolicyResult> putAccessPointPolicyAsync(final PutAccessPointPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutAccessPointPolicyRequest, PutAccessPointPolicyResult> asyncHandler) {
        final PutAccessPointPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutAccessPointPolicyResult>() {
            @Override
            public PutAccessPointPolicyResult call() throws Exception {
                PutAccessPointPolicyResult result = null;

                try {
                    result = executePutAccessPointPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointPolicyForObjectLambdaResult> putAccessPointPolicyForObjectLambdaAsync(
            PutAccessPointPolicyForObjectLambdaRequest request) {

        return putAccessPointPolicyForObjectLambdaAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutAccessPointPolicyForObjectLambdaResult> putAccessPointPolicyForObjectLambdaAsync(
            final PutAccessPointPolicyForObjectLambdaRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutAccessPointPolicyForObjectLambdaRequest, PutAccessPointPolicyForObjectLambdaResult> asyncHandler) {
        final PutAccessPointPolicyForObjectLambdaRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutAccessPointPolicyForObjectLambdaResult>() {
            @Override
            public PutAccessPointPolicyForObjectLambdaResult call() throws Exception {
                PutAccessPointPolicyForObjectLambdaResult result = null;

                try {
                    result = executePutAccessPointPolicyForObjectLambda(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutBucketLifecycleConfigurationResult> putBucketLifecycleConfigurationAsync(
            PutBucketLifecycleConfigurationRequest request) {

        return putBucketLifecycleConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBucketLifecycleConfigurationResult> putBucketLifecycleConfigurationAsync(
            final PutBucketLifecycleConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutBucketLifecycleConfigurationRequest, PutBucketLifecycleConfigurationResult> asyncHandler) {
        final PutBucketLifecycleConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutBucketLifecycleConfigurationResult>() {
            @Override
            public PutBucketLifecycleConfigurationResult call() throws Exception {
                PutBucketLifecycleConfigurationResult result = null;

                try {
                    result = executePutBucketLifecycleConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutBucketPolicyResult> putBucketPolicyAsync(PutBucketPolicyRequest request) {

        return putBucketPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBucketPolicyResult> putBucketPolicyAsync(final PutBucketPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutBucketPolicyRequest, PutBucketPolicyResult> asyncHandler) {
        final PutBucketPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutBucketPolicyResult>() {
            @Override
            public PutBucketPolicyResult call() throws Exception {
                PutBucketPolicyResult result = null;

                try {
                    result = executePutBucketPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutBucketReplicationResult> putBucketReplicationAsync(PutBucketReplicationRequest request) {

        return putBucketReplicationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBucketReplicationResult> putBucketReplicationAsync(final PutBucketReplicationRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutBucketReplicationRequest, PutBucketReplicationResult> asyncHandler) {
        final PutBucketReplicationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutBucketReplicationResult>() {
            @Override
            public PutBucketReplicationResult call() throws Exception {
                PutBucketReplicationResult result = null;

                try {
                    result = executePutBucketReplication(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutBucketTaggingResult> putBucketTaggingAsync(PutBucketTaggingRequest request) {

        return putBucketTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBucketTaggingResult> putBucketTaggingAsync(final PutBucketTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutBucketTaggingRequest, PutBucketTaggingResult> asyncHandler) {
        final PutBucketTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutBucketTaggingResult>() {
            @Override
            public PutBucketTaggingResult call() throws Exception {
                PutBucketTaggingResult result = null;

                try {
                    result = executePutBucketTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutBucketVersioningResult> putBucketVersioningAsync(PutBucketVersioningRequest request) {

        return putBucketVersioningAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutBucketVersioningResult> putBucketVersioningAsync(final PutBucketVersioningRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutBucketVersioningRequest, PutBucketVersioningResult> asyncHandler) {
        final PutBucketVersioningRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutBucketVersioningResult>() {
            @Override
            public PutBucketVersioningResult call() throws Exception {
                PutBucketVersioningResult result = null;

                try {
                    result = executePutBucketVersioning(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutJobTaggingResult> putJobTaggingAsync(PutJobTaggingRequest request) {

        return putJobTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutJobTaggingResult> putJobTaggingAsync(final PutJobTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutJobTaggingRequest, PutJobTaggingResult> asyncHandler) {
        final PutJobTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutJobTaggingResult>() {
            @Override
            public PutJobTaggingResult call() throws Exception {
                PutJobTaggingResult result = null;

                try {
                    result = executePutJobTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutMultiRegionAccessPointPolicyResult> putMultiRegionAccessPointPolicyAsync(
            PutMultiRegionAccessPointPolicyRequest request) {

        return putMultiRegionAccessPointPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutMultiRegionAccessPointPolicyResult> putMultiRegionAccessPointPolicyAsync(
            final PutMultiRegionAccessPointPolicyRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutMultiRegionAccessPointPolicyRequest, PutMultiRegionAccessPointPolicyResult> asyncHandler) {
        final PutMultiRegionAccessPointPolicyRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutMultiRegionAccessPointPolicyResult>() {
            @Override
            public PutMultiRegionAccessPointPolicyResult call() throws Exception {
                PutMultiRegionAccessPointPolicyResult result = null;

                try {
                    result = executePutMultiRegionAccessPointPolicy(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(PutPublicAccessBlockRequest request) {

        return putPublicAccessBlockAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutPublicAccessBlockResult> putPublicAccessBlockAsync(final PutPublicAccessBlockRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutPublicAccessBlockRequest, PutPublicAccessBlockResult> asyncHandler) {
        final PutPublicAccessBlockRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutPublicAccessBlockResult>() {
            @Override
            public PutPublicAccessBlockResult call() throws Exception {
                PutPublicAccessBlockResult result = null;

                try {
                    result = executePutPublicAccessBlock(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutStorageLensConfigurationResult> putStorageLensConfigurationAsync(PutStorageLensConfigurationRequest request) {

        return putStorageLensConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutStorageLensConfigurationResult> putStorageLensConfigurationAsync(final PutStorageLensConfigurationRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutStorageLensConfigurationRequest, PutStorageLensConfigurationResult> asyncHandler) {
        final PutStorageLensConfigurationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutStorageLensConfigurationResult>() {
            @Override
            public PutStorageLensConfigurationResult call() throws Exception {
                PutStorageLensConfigurationResult result = null;

                try {
                    result = executePutStorageLensConfiguration(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<PutStorageLensConfigurationTaggingResult> putStorageLensConfigurationTaggingAsync(
            PutStorageLensConfigurationTaggingRequest request) {

        return putStorageLensConfigurationTaggingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutStorageLensConfigurationTaggingResult> putStorageLensConfigurationTaggingAsync(
            final PutStorageLensConfigurationTaggingRequest request,
            final com.amazonaws.handlers.AsyncHandler<PutStorageLensConfigurationTaggingRequest, PutStorageLensConfigurationTaggingResult> asyncHandler) {
        final PutStorageLensConfigurationTaggingRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<PutStorageLensConfigurationTaggingResult>() {
            @Override
            public PutStorageLensConfigurationTaggingResult call() throws Exception {
                PutStorageLensConfigurationTaggingResult result = null;

                try {
                    result = executePutStorageLensConfigurationTagging(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<SubmitMultiRegionAccessPointRoutesResult> submitMultiRegionAccessPointRoutesAsync(
            SubmitMultiRegionAccessPointRoutesRequest request) {

        return submitMultiRegionAccessPointRoutesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<SubmitMultiRegionAccessPointRoutesResult> submitMultiRegionAccessPointRoutesAsync(
            final SubmitMultiRegionAccessPointRoutesRequest request,
            final com.amazonaws.handlers.AsyncHandler<SubmitMultiRegionAccessPointRoutesRequest, SubmitMultiRegionAccessPointRoutesResult> asyncHandler) {
        final SubmitMultiRegionAccessPointRoutesRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<SubmitMultiRegionAccessPointRoutesResult>() {
            @Override
            public SubmitMultiRegionAccessPointRoutesResult call() throws Exception {
                SubmitMultiRegionAccessPointRoutesResult result = null;

                try {
                    result = executeSubmitMultiRegionAccessPointRoutes(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(final TagResourceRequest request,
            final com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<TagResourceResult>() {
            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;

                try {
                    result = executeTagResource(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(final UntagResourceRequest request,
            final com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<UntagResourceResult>() {
            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;

                try {
                    result = executeUntagResource(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessGrantsLocationResult> updateAccessGrantsLocationAsync(UpdateAccessGrantsLocationRequest request) {

        return updateAccessGrantsLocationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateAccessGrantsLocationResult> updateAccessGrantsLocationAsync(final UpdateAccessGrantsLocationRequest request,
            final com.amazonaws.handlers.AsyncHandler<UpdateAccessGrantsLocationRequest, UpdateAccessGrantsLocationResult> asyncHandler) {
        final UpdateAccessGrantsLocationRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<UpdateAccessGrantsLocationResult>() {
            @Override
            public UpdateAccessGrantsLocationResult call() throws Exception {
                UpdateAccessGrantsLocationResult result = null;

                try {
                    result = executeUpdateAccessGrantsLocation(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<UpdateJobPriorityResult> updateJobPriorityAsync(UpdateJobPriorityRequest request) {

        return updateJobPriorityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateJobPriorityResult> updateJobPriorityAsync(final UpdateJobPriorityRequest request,
            final com.amazonaws.handlers.AsyncHandler<UpdateJobPriorityRequest, UpdateJobPriorityResult> asyncHandler) {
        final UpdateJobPriorityRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<UpdateJobPriorityResult>() {
            @Override
            public UpdateJobPriorityResult call() throws Exception {
                UpdateJobPriorityResult result = null;

                try {
                    result = executeUpdateJobPriority(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<UpdateJobStatusResult> updateJobStatusAsync(UpdateJobStatusRequest request) {

        return updateJobStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateJobStatusResult> updateJobStatusAsync(final UpdateJobStatusRequest request,
            final com.amazonaws.handlers.AsyncHandler<UpdateJobStatusRequest, UpdateJobStatusResult> asyncHandler) {
        final UpdateJobStatusRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<UpdateJobStatusResult>() {
            @Override
            public UpdateJobStatusResult call() throws Exception {
                UpdateJobStatusResult result = null;

                try {
                    result = executeUpdateJobStatus(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public java.util.concurrent.Future<UpdateStorageLensGroupResult> updateStorageLensGroupAsync(UpdateStorageLensGroupRequest request) {

        return updateStorageLensGroupAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateStorageLensGroupResult> updateStorageLensGroupAsync(final UpdateStorageLensGroupRequest request,
            final com.amazonaws.handlers.AsyncHandler<UpdateStorageLensGroupRequest, UpdateStorageLensGroupResult> asyncHandler) {
        final UpdateStorageLensGroupRequest finalRequest = beforeClientExecution(request);

        return executorService.submit(new java.util.concurrent.Callable<UpdateStorageLensGroupResult>() {
            @Override
            public UpdateStorageLensGroupResult call() throws Exception {
                UpdateStorageLensGroupResult result = null;

                try {
                    result = executeUpdateStorageLensGroup(finalRequest);
                } catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }

                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    /**
     * Shuts down the client, releasing all managed resources. This includes forcibly terminating all pending
     * asynchronous service calls. Clients who wish to give pending asynchronous service calls time to complete should
     * call {@code getExecutorService().shutdown()} followed by {@code getExecutorService().awaitTermination()} prior to
     * calling this method.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        executorService.shutdownNow();
    }
}
