/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.services.s3control.S3ControlResponseMetadata;
import com.amazonaws.services.s3control.model.MultiRegionAccessPointReport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListMultiRegionAccessPointsResult
extends AmazonWebServiceResult<S3ControlResponseMetadata>
implements Serializable,
Cloneable {
    private List<MultiRegionAccessPointReport> accessPoints;
    private String nextToken;

    public List<MultiRegionAccessPointReport> getAccessPoints() {
        return this.accessPoints;
    }

    public void setAccessPoints(Collection<MultiRegionAccessPointReport> accessPoints) {
        if (accessPoints == null) {
            this.accessPoints = null;
            return;
        }
        this.accessPoints = new ArrayList<MultiRegionAccessPointReport>(accessPoints);
    }

    public ListMultiRegionAccessPointsResult withAccessPoints(MultiRegionAccessPointReport ... accessPoints) {
        if (this.accessPoints == null) {
            this.setAccessPoints(new ArrayList<MultiRegionAccessPointReport>(accessPoints.length));
        }
        for (MultiRegionAccessPointReport ele : accessPoints) {
            this.accessPoints.add(ele);
        }
        return this;
    }

    public ListMultiRegionAccessPointsResult withAccessPoints(Collection<MultiRegionAccessPointReport> accessPoints) {
        this.setAccessPoints(accessPoints);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMultiRegionAccessPointsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessPoints() != null) {
            sb.append("AccessPoints: ").append(this.getAccessPoints()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiRegionAccessPointsResult)) {
            return false;
        }
        ListMultiRegionAccessPointsResult other = (ListMultiRegionAccessPointsResult)obj;
        if (other.getAccessPoints() == null ^ this.getAccessPoints() == null) {
            return false;
        }
        if (other.getAccessPoints() != null && !other.getAccessPoints().equals(this.getAccessPoints())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessPoints() == null ? 0 : this.getAccessPoints().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListMultiRegionAccessPointsResult clone() {
        try {
            return (ListMultiRegionAccessPointsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

