/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.TransitionStorageClass;
import java.io.Serializable;

public class NoncurrentVersionTransition
implements Serializable,
Cloneable {
    private Integer noncurrentDays;
    private String storageClass;

    public void setNoncurrentDays(Integer noncurrentDays) {
        this.noncurrentDays = noncurrentDays;
    }

    public Integer getNoncurrentDays() {
        return this.noncurrentDays;
    }

    public NoncurrentVersionTransition withNoncurrentDays(Integer noncurrentDays) {
        this.setNoncurrentDays(noncurrentDays);
        return this;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public NoncurrentVersionTransition withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public NoncurrentVersionTransition withStorageClass(TransitionStorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNoncurrentDays() != null) {
            sb.append("NoncurrentDays: ").append(this.getNoncurrentDays()).append(",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: ").append(this.getStorageClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoncurrentVersionTransition)) {
            return false;
        }
        NoncurrentVersionTransition other = (NoncurrentVersionTransition)obj;
        if (other.getNoncurrentDays() == null ^ this.getNoncurrentDays() == null) {
            return false;
        }
        if (other.getNoncurrentDays() != null && !other.getNoncurrentDays().equals(this.getNoncurrentDays())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        return other.getStorageClass() == null || other.getStorageClass().equals(this.getStorageClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNoncurrentDays() == null ? 0 : this.getNoncurrentDays().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        return hashCode;
    }

    public NoncurrentVersionTransition clone() {
        try {
            return (NoncurrentVersionTransition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

